import { type ExtractPropTypes, type PropType, type SetupContext } from 'vue';
import { Attribute } from '../utils/attribute';
import { type DateSource } from '../utils/date/helpers';
import { type DateRangeCell, DateRangeContext } from '../utils/date/range';
import { type CalendarDay, type CalendarWeek, type Page, type PageAddress, type TitlePosition } from '../utils/page';
import { type PopoverVisibility } from '../utils/popovers';
export type CalendarView = 'daily' | 'weekly' | 'monthly';
export type MoveTarget = DateSource | PageAddress;
export type MoveTransition = 'none' | 'fade' | 'slide-v' | 'slide-h';
export interface MoveOptions {
    position: number;
    view: CalendarView;
    transition: MoveTransition;
    force: boolean;
    fromPage: PageAddress;
    toPage: PageAddress;
}
export interface RefreshOptions {
    page: PageAddress;
    position: number;
    force: boolean;
    transition: MoveTransition;
}
export type DayCells = Record<number, {
    day: CalendarDay;
    cells: DateRangeCell<Attribute>[];
}>;
export type CalendarProps = Readonly<ExtractPropTypes<typeof propsDef>>;
export type CalendarContext = ReturnType<typeof createCalendar>;
export declare const propsDef: {
    view: {
        type: PropType<CalendarView>;
        default: string;
        validator(value: string): boolean;
    };
    rows: {
        type: NumberConstructor;
        default: number;
    };
    columns: {
        type: NumberConstructor;
        default: number;
    };
    step: NumberConstructor;
    titlePosition: {
        type: PropType<TitlePosition>;
        default: () => TitlePosition;
    };
    navVisibility: {
        type: PropType<PopoverVisibility>;
        default: () => PopoverVisibility;
    };
    showWeeknumbers: (BooleanConstructor | StringConstructor)[];
    showIsoWeeknumbers: (BooleanConstructor | StringConstructor)[];
    expanded: BooleanConstructor;
    borderless: BooleanConstructor;
    transparent: BooleanConstructor;
    initialPage: PropType<PageAddress>;
    initialPagePosition: {
        type: NumberConstructor;
        default: number;
    };
    minPage: PropType<PageAddress>;
    maxPage: PropType<PageAddress>;
    transition: PropType<MoveTransition>;
    attributes: PropType<Partial<{
        key: string | number;
        hashcode: string;
        content: import("../utils/glyph").ContentConfig;
        highlight: import("../utils/glyph").HighlightConfig;
        dot: import("../utils/glyph").DotConfig;
        bar: import("../utils/glyph").BarConfig;
        popover: Partial<{
            label: string;
            visibility: PopoverVisibility;
            placement: import("@popperjs/core").Placement;
            hideIndicator: boolean;
            isInteractive: boolean;
        }>;
        event: Partial<{
            label: string;
        }>;
        dates: import("../utils/date/range").DateRangeSource[];
        customData: any;
        order: number;
        pinPage: boolean;
    }>[]>;
    trimWeeks: BooleanConstructor;
    disablePageSwipe: BooleanConstructor;
    color: {
        type: StringConstructor;
        default: () => any;
    };
    isDark: {
        type: PropType<boolean | "system" | import("vue-screen-utils").DarkModeClassConfig>;
        default: () => any;
    };
    firstDayOfWeek: PropType<import("../utils/date/helpers").DayOfWeek>;
    masks: ObjectConstructor;
    locale: PropType<string | import("../utils/locale").default | Record<string, any>>;
    timezone: StringConstructor;
    minDate: null;
    maxDate: null;
    disabledDates: null;
};
export declare const emitsDef: string[];
export declare function createCalendar(props: CalendarProps, { slots, emit }: Pick<SetupContext, 'slots' | 'emit'>): {
    emit: ((event: string, ...args: any[]) => void) | ((event: string, ...args: any[]) => void);
    containerRef: import("vue").Ref<{
        querySelector: {
            <K extends keyof HTMLElementTagNameMap>(selectors: K): HTMLElementTagNameMap[K] | null;
            <K_1 extends keyof SVGElementTagNameMap>(selectors: K_1): SVGElementTagNameMap[K_1] | null;
            <E extends Element = Element>(selectors: string): E | null;
        };
        addEventListener: Function;
        removeEventListener: Function;
        dispatchEvent: Function;
    } | null>;
    focusedDay: import("vue").Ref<{
        id: string;
        position: number;
        label: string;
        ariaLabel: string;
        weekdayPosition: number;
        weekdayPositionFromEnd: number;
        weekPosition: number;
        isoWeeknumber: number;
        startDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        noonDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        endDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        isToday: boolean;
        isFirstDay: boolean;
        isLastDay: boolean;
        isDisabled: boolean;
        isFocusable: boolean;
        isFocused: boolean;
        inMonth: boolean;
        inPrevMonth: boolean;
        inNextMonth: boolean;
        onTop: boolean;
        onBottom: boolean;
        onLeft: boolean;
        onRight: boolean;
        classes: (string | Object)[];
        locale: {
            id: any;
            daysInWeek: number;
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            masks: any;
            timezone: string | undefined;
            hourLabels: string[];
            dayNames: string[];
            dayNamesShort: string[];
            dayNamesShorter: string[];
            dayNamesNarrow: string[];
            monthNames: string[];
            monthNamesShort: string[];
            relativeTimeNames: {
                day?: string | undefined;
                week?: string | undefined;
                month?: string | undefined;
                year?: string | undefined;
                days?: string | undefined;
                weeks?: string | undefined;
                seconds?: string | undefined;
                minutes?: string | undefined;
                hours?: string | undefined;
                months?: string | undefined;
                years?: string | undefined;
                quarter?: string | undefined;
                quarters?: string | undefined;
                hour?: string | undefined;
                minute?: string | undefined;
                second?: string | undefined;
            };
            amPm: [string, string];
            monthCache: {
                keys: string[];
                store: Record<string, import("../utils/date/helpers").MonthParts>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
            };
            pageCache: {
                keys: string[];
                store: Record<string, import("../utils/page").CachedPage>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                get: (...args: any[]) => import("../utils/page").CachedPage;
                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
            };
            formatDate: (date: Date, masks: string | string[]) => string;
            parseDate: (dateString: string, mask: string | string[]) => Date;
            toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
            toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
            range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
            getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
            getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
            getPage: (config: import("../utils/page").PageConfig) => Page;
            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getHourLabels: () => string[];
            getDayId: (date: Date) => string;
        };
        dayIndex: number;
        day: number;
        dayFromEnd: number;
        weekday: number;
        weekdayOrdinal: number;
        weekdayOrdinalFromEnd: number;
        week: number;
        weekFromEnd: number;
        weeknumber: number;
        month: number;
        year: number;
        date: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
    } | null>;
    inTransition: import("vue").Ref<boolean>;
    navPopoverId: import("vue").Ref<symbol>;
    dayPopoverId: import("vue").Ref<symbol>;
    view: import("vue").Ref<CalendarView>;
    pages: import("vue").Ref<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    }[]>;
    transitionName: import("vue").Ref<string>;
    theme: import("vue").ComputedRef<import("../utils/theme").Theme>;
    color: import("vue").ComputedRef<string>;
    displayMode: import("vue").ComputedRef<"light" | "dark">;
    locale: import("vue").ComputedRef<import("../utils/locale").default>;
    masks: import("vue").ComputedRef<any>;
    attributes: import("vue").ComputedRef<Attribute[]>;
    disabledAttribute: import("vue").ComputedRef<Attribute>;
    disabledDates: import("vue").ComputedRef<import("../utils/date/range").DateRange[]>;
    attributeContext: import("vue").ComputedRef<DateRangeContext>;
    days: import("vue").ComputedRef<CalendarDay[]>;
    dayCells: import("vue").ComputedRef<DayCells>;
    count: import("vue").ComputedRef<number>;
    step: import("vue").ComputedRef<number>;
    firstPage: import("vue").ComputedRef<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    } | null>;
    lastPage: import("vue").ComputedRef<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    } | null>;
    canMovePrev: import("vue").ComputedRef<boolean>;
    canMoveNext: import("vue").ComputedRef<boolean>;
    minPage: import("vue").ComputedRef<PageAddress | null>;
    maxPage: import("vue").ComputedRef<PageAddress | null>;
    isMonthly: import("vue").ComputedRef<boolean>;
    isWeekly: import("vue").ComputedRef<boolean>;
    isDaily: import("vue").ComputedRef<boolean>;
    navVisibility: import("vue").ComputedRef<PopoverVisibility>;
    showWeeknumbers: import("vue").ComputedRef<boolean>;
    showIsoWeeknumbers: import("vue").ComputedRef<boolean>;
    getDateAddress: (date: DateSource) => PageAddress;
    canMove: (target: MoveTarget, opts?: Partial<MoveOptions>) => boolean;
    canMoveBy: (pages: number, opts?: Partial<MoveOptions>) => boolean;
    move: (target: MoveTarget, opts?: Partial<MoveOptions>) => Promise<boolean>;
    moveBy: (pages: number, opts?: Partial<MoveOptions>) => Promise<boolean>;
    movePrev: () => Promise<boolean>;
    moveNext: () => Promise<boolean>;
    onTransitionBeforeEnter: () => void;
    onTransitionAfterEnter: () => void;
    tryFocusDate: (date: Date) => boolean;
    focusDate: (date: Date, opts?: Partial<MoveOptions>) => Promise<boolean>;
    onKeydown: (event: KeyboardEvent) => void;
    onDayKeydown: (day: CalendarDay, event: KeyboardEvent) => void;
    onDayClick: (day: CalendarDay, event: MouseEvent) => void;
    onDayMouseenter: (day: CalendarDay, event: MouseEvent) => void;
    onDayMouseleave: (day: CalendarDay, event: MouseEvent) => void;
    onDayFocusin: (day: CalendarDay, event: FocusEvent | null) => void;
    onDayFocusout: (day: CalendarDay, event: FocusEvent) => void;
    onWeeknumberClick: (week: CalendarWeek, event: MouseEvent) => void;
};
export declare function useCalendar(): CalendarContext;
