import { type ExtractPropTypes, type PropType } from 'vue';
import { type Event, type EventConfig } from '../utils/calendar/event';
import { DateRange, DateRangeContext } from '../utils/date/range';
import type { CalendarDay } from '../utils/page';
export type GridStateEvent = 'GRID_CURSOR_DOWN' | 'GRID_CURSOR_DOWN_SHIFT' | 'GRID_CURSOR_MOVE' | 'GRID_CURSOR_MOVE_SHIFT' | 'GRID_CURSOR_UP' | 'GRID_CURSOR_UP_SHIFT' | 'EVENT_CURSOR_DOWN' | 'EVENT_CURSOR_DOWN_SHIFT' | 'EVENT_CURSOR_MOVE' | 'EVENT_CURSOR_MOVE_SHIFT' | 'EVENT_RESIZE_START_CURSOR_DOWN' | 'EVENT_RESIZE_START_CURSOR_DOWN_SHIFT' | 'EVENT_RESIZE_END_CURSOR_DOWN' | 'EVENT_RESIZE_END_CURSOR_DOWN_SHIFT' | 'ESCAPE';
export interface Point {
    x: number;
    y: number;
}
export interface DragOffset {
    weekdays: number;
    weeks: number;
    ms: number;
}
export interface ResizeOffset {
    weekdays: number;
    weeks: number;
    ms: number;
}
export interface DragOriginState {
    position: number;
    date: Date;
    day: CalendarDay;
    event: Event;
    eventSelected: boolean;
    ms: number;
}
export interface ResizeOriginState {
    position: number;
    day: CalendarDay;
    event: Event;
    isWeekly: boolean;
    isStart: boolean;
    isNew: boolean;
    ms: number;
}
export interface CreateOriginState {
    position: number;
    date: Date;
    day: CalendarDay;
    isWeekly: boolean;
}
export declare const emits: string[];
export declare const propsDef: {
    events: {
        type: PropType<EventConfig[]>;
        default: () => never[];
    };
    view: {
        type: PropType<import("./calendar").CalendarView>;
        default: string;
        validator(value: string): boolean;
    };
    rows: {
        type: NumberConstructor;
        default: number;
    };
    columns: {
        type: NumberConstructor;
        default: number;
    };
    step: NumberConstructor;
    titlePosition: {
        type: PropType<import("../utils/page").TitlePosition>;
        default: () => import("../utils/page").TitlePosition;
    };
    navVisibility: {
        type: PropType<import("../utils/popovers").PopoverVisibility>;
        default: () => import("../utils/popovers").PopoverVisibility;
    };
    showWeeknumbers: (BooleanConstructor | StringConstructor)[];
    showIsoWeeknumbers: (BooleanConstructor | StringConstructor)[];
    expanded: BooleanConstructor;
    borderless: BooleanConstructor;
    transparent: BooleanConstructor;
    initialPage: PropType<import("../utils/page").PageAddress>;
    initialPagePosition: {
        type: NumberConstructor;
        default: number;
    };
    minPage: PropType<import("../utils/page").PageAddress>;
    maxPage: PropType<import("../utils/page").PageAddress>;
    transition: PropType<import("./calendar").MoveTransition>;
    attributes: PropType<Partial<{
        key: string | number;
        hashcode: string;
        content: import("../utils/glyph").ContentConfig;
        highlight: import("../utils/glyph").HighlightConfig;
        dot: import("../utils/glyph").DotConfig;
        bar: import("../utils/glyph").BarConfig;
        popover: Partial<{
            label: string;
            visibility: import("../utils/popovers").PopoverVisibility;
            placement: import("@popperjs/core").Placement;
            hideIndicator: boolean;
            isInteractive: boolean;
        }>;
        event: Partial<{
            label: string;
        }>;
        dates: import("../utils/date/range").DateRangeSource[];
        customData: any;
        order: number;
        pinPage: boolean;
    }>[]>;
    trimWeeks: BooleanConstructor;
    disablePageSwipe: BooleanConstructor;
    color: {
        type: StringConstructor;
        default: () => any;
    };
    isDark: {
        type: PropType<boolean | "system" | import("vue-screen-utils").DarkModeClassConfig>;
        default: () => any;
    };
    firstDayOfWeek: PropType<import("../utils/date/helpers").DayOfWeek>;
    masks: ObjectConstructor;
    locale: PropType<string | import("../utils/locale").default | Record<string, any>>;
    timezone: StringConstructor;
    minDate: null;
    maxDate: null;
    disabledDates: null;
};
export type CalendarGridProps = Readonly<ExtractPropTypes<typeof propsDef>>;
export type CalendarGridContext = ReturnType<typeof createCalendarGrid>;
export declare function createCalendarGrid(props: CalendarGridProps, { emit, slots }: any): {
    dailyGridRef: import("vue").Ref<{
        getBoundingClientRect: () => DOMRect;
        contains: (other: Node | null) => boolean;
    } | null>;
    weeklyGridRef: import("vue").Ref<{
        getBoundingClientRect: () => DOMRect;
        contains: (other: Node | null) => boolean;
    } | null>;
    cellPopoverRef: import("vue").Ref<import("vue").DefineComponent<{
        popoverId: {
            type: StringConstructor;
            default: string;
        };
    }, {
        displayMode: import("vue").ComputedRef<"light" | "dark">;
        color: import("vue").ComputedRef<string>;
        show: (event: {
            refSelector: string;
            isMultiDay: boolean;
            isWeekly: boolean;
            durationMs: number;
            durationMinutes: number;
            startDate: Date;
            startDateTime: number;
            startTimeLabel: string;
            endDate: Date;
            endDateTime: number;
            endTimeLabel: string;
            timeLabel: string;
            isSolid: boolean;
            dragIsDirty: boolean;
            formatDate: (date: Date, mask: string) => string;
            formatTime: (date: Date) => string;
            resizeToConstraints: () => void;
            startResize: (day: CalendarDay, isStart: boolean) => void;
            updateResize: (offset: ResizeOffset) => void;
            stopResize: () => void;
            startDrag: (day: CalendarDay) => void;
            updateDrag: (offset: DragOffset) => void;
            stopDrag: () => false | undefined;
            compareTo: (b: any) => number;
            key: any;
            summary: string;
            description: string;
            range: DateRange;
            allDay: boolean;
            color: string;
            fill: string;
            selected: boolean;
            draggable: boolean;
            dragging: boolean;
            resizable: boolean;
            resizing: boolean;
            editing: boolean;
            order: number;
            snapMinutes: number;
            minDurationMinutes: number;
            maxDurationMinutes: number;
            popover: Partial<import("../utils/popovers").PopoverOptions> | null;
            resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
            dragOrigin: import("../utils/calendar/event").DragOrigin | null;
        }) => void;
        update: (event: {
            refSelector: string;
            isMultiDay: boolean;
            isWeekly: boolean;
            durationMs: number;
            durationMinutes: number;
            startDate: Date;
            startDateTime: number;
            startTimeLabel: string;
            endDate: Date;
            endDateTime: number;
            endTimeLabel: string;
            timeLabel: string;
            isSolid: boolean;
            dragIsDirty: boolean;
            formatDate: (date: Date, mask: string) => string;
            formatTime: (date: Date) => string;
            resizeToConstraints: () => void;
            startResize: (day: CalendarDay, isStart: boolean) => void;
            updateResize: (offset: ResizeOffset) => void;
            stopResize: () => void;
            startDrag: (day: CalendarDay) => void;
            updateDrag: (offset: DragOffset) => void;
            stopDrag: () => false | undefined;
            compareTo: (b: any) => number;
            key: any;
            summary: string;
            description: string;
            range: DateRange;
            allDay: boolean;
            color: string;
            fill: string;
            selected: boolean;
            draggable: boolean;
            dragging: boolean;
            resizable: boolean;
            resizing: boolean;
            editing: boolean;
            order: number;
            snapMinutes: number;
            minDurationMinutes: number;
            maxDurationMinutes: number;
            popover: Partial<import("../utils/popovers").PopoverOptions> | null;
            resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
            dragOrigin: import("../utils/calendar/event").DragOrigin | null;
        }) => void;
        hide: () => void;
        isVisible: () => boolean;
        onAfterHide(): void;
        event: import("vue").Ref<{
            refSelector: string;
            isMultiDay: boolean;
            isWeekly: boolean;
            durationMs: number;
            durationMinutes: number;
            startDate: Date;
            startDateTime: number;
            startTimeLabel: string;
            endDate: Date;
            endDateTime: number;
            endTimeLabel: string;
            timeLabel: string;
            isSolid: boolean;
            dragIsDirty: boolean;
            formatDate: (date: Date, mask: string) => string;
            formatTime: (date: Date) => string;
            resizeToConstraints: () => void;
            startResize: (day: CalendarDay, isStart: boolean) => void;
            updateResize: (offset: ResizeOffset) => void;
            stopResize: () => void;
            startDrag: (day: CalendarDay) => void;
            updateDrag: (offset: DragOffset) => void;
            stopDrag: () => false | undefined;
            compareTo: (b: any) => number;
            key: any;
            summary: string;
            description: string;
            range: DateRange;
            allDay: boolean;
            color: string;
            fill: string;
            selected: boolean;
            draggable: boolean;
            dragging: boolean;
            resizable: boolean;
            resizing: boolean;
            editing: boolean;
            order: number;
            snapMinutes: number;
            minDurationMinutes: number;
            maxDurationMinutes: number;
            popover: Partial<import("../utils/popovers").PopoverOptions> | null;
            resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
            dragOrigin: import("../utils/calendar/event").DragOrigin | null;
        } | null>;
        popoverRef: import("vue").Ref<null>;
    }, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<ExtractPropTypes<{
        popoverId: {
            type: StringConstructor;
            default: string;
        };
    }>>, {
        popoverId: string;
    }> | undefined>;
    dayColumns: import("vue").ComputedRef<number>;
    dayRows: import("vue").ComputedRef<number>;
    snapMinutes: import("vue").Ref<number>;
    snapMs: import("vue").ComputedRef<number>;
    pixelsPerHour: import("vue").Ref<number>;
    isTouch: import("vue").Ref<boolean>;
    events: import("vue").ComputedRef<{
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }[]>;
    eventsMap: import("vue").Ref<Record<any, {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }>>;
    selectedEvents: import("vue").ComputedRef<{
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }[]>;
    hasSelectedEvents: import("vue").ComputedRef<boolean>;
    eventsContext: import("vue").ComputedRef<DateRangeContext>;
    detailEvent: import("vue").Ref<{
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        startDateTime: number;
        startTimeLabel: string;
        endDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: {
            order: number;
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            start: {
                milliseconds: number;
                seconds: number;
                minutes: number;
                hours: number;
                time: number;
                dateTime: number;
                isValid: boolean;
                timezoneOffset: number;
                isPm?: boolean | undefined;
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            } | null;
            end: {
                milliseconds: number;
                seconds: number;
                minutes: number;
                hours: number;
                time: number;
                dateTime: number;
                isValid: boolean;
                timezoneOffset: number;
                isPm?: boolean | undefined;
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            } | null;
            repeat: {
                validated: boolean;
                config: import("../utils/date/repeat").DateRepeatFn | {
                    every?: import("../utils/date/repeat").RepeatIntervalShort | [number, import("../utils/date/repeat").RepeatInterval] | undefined;
                    from?: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    } | undefined;
                    until?: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    } | undefined;
                    weekdays?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").DayOfWeek> | undefined;
                    days?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").DayInMonth> | undefined;
                    weeks?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").WeekInMonth> | undefined;
                    months?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").MonthInYear> | undefined;
                    years?: import("../utils/date/rules").SingleOrArray<number> | undefined;
                    ordinalWeekdays?: import("../utils/date/rules").SingleOrArray<number[]> | undefined;
                    on?: import("../utils/date/repeat").DateRepeatFn | any | (import("../utils/date/repeat").DateRepeatFn | any)[] | undefined;
                };
                type: import("../utils/date/rules").GroupRuleType;
                from: {
                    milliseconds: number;
                    seconds: number;
                    minutes: number;
                    hours: number;
                    time: number;
                    dateTime: number;
                    isValid: boolean;
                    timezoneOffset: number;
                    isPm?: boolean | undefined;
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                } | undefined;
                until: {
                    milliseconds: number;
                    seconds: number;
                    minutes: number;
                    hours: number;
                    time: number;
                    dateTime: number;
                    isValid: boolean;
                    timezoneOffset: number;
                    isPm?: boolean | undefined;
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                } | undefined;
                rules: {
                    type: import("../utils/date/rules").RuleType;
                    passes: (dayParts: import("../utils/date/helpers").DayParts) => boolean;
                }[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                getObjectRules: (config: any) => import("../utils/date/rules").Rule<import("../utils/date/rules").RuleType>[];
                passes: (dayParts: import("../utils/date/helpers").DayParts) => boolean;
            } | null;
            readonly opts: {
                order: number;
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
            };
            readonly hasRepeat: boolean;
            readonly isSingleDay: boolean | null;
            readonly isMultiDay: boolean;
            readonly daySpan: number;
            startsOnDay: (dayParts: import("../utils/date/helpers").DayParts) => boolean;
            intersectsDay: (dayIndex: number) => boolean;
            intersectsRange: (range: DateRange) => boolean;
            intersectsDayRange: (startDayIndex: number, endDayIndex: number) => boolean;
        };
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: {
            id?: PropertyKey | undefined;
            visibility?: import("../utils/popovers").PopoverVisibility | undefined;
            isInteractive?: boolean | undefined;
            autoHide?: boolean | undefined;
            force?: boolean | undefined;
            target?: unknown;
            placement?: import("@popperjs/core").Placement | undefined;
            modifiers?: any;
            data?: any;
            showDelay?: number | undefined;
            hideDelay?: number | undefined;
        } | null;
        resizeOrigin: {
            start: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            end: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isStart: boolean;
        } | null;
        dragOrigin: {
            day: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            };
            start: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            end: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            minOffsetWeeks: number;
            maxOffsetWeeks: number;
            minOffsetWeekdays: number;
            maxOffsetWeekdays: number;
            minOffsetMs: number;
            maxOffsetMs: number;
            durationMs: number;
        } | null;
    } | null>;
    resizing: import("vue").Ref<boolean>;
    dragging: import("vue").Ref<boolean>;
    gridStyle: import("vue").ComputedRef<{
        height: string;
    }>;
    fill: import("vue").Ref<string>;
    page: import("vue").ComputedRef<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: import("../utils/page").TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    }>;
    days: import("vue").ComputedRef<{
        id: string;
        position: number;
        label: string;
        ariaLabel: string;
        weekdayPosition: number;
        weekdayPositionFromEnd: number;
        weekPosition: number;
        isoWeeknumber: number;
        startDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        noonDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        endDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        isToday: boolean;
        isFirstDay: boolean;
        isLastDay: boolean;
        isDisabled: boolean;
        isFocusable: boolean;
        isFocused: boolean;
        inMonth: boolean;
        inPrevMonth: boolean;
        inNextMonth: boolean;
        onTop: boolean;
        onBottom: boolean;
        onLeft: boolean;
        onRight: boolean;
        classes: (string | Object)[];
        locale: {
            id: any;
            daysInWeek: number;
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            masks: any;
            timezone: string | undefined;
            hourLabels: string[];
            dayNames: string[];
            dayNamesShort: string[];
            dayNamesShorter: string[];
            dayNamesNarrow: string[];
            monthNames: string[];
            monthNamesShort: string[];
            relativeTimeNames: {
                day?: string | undefined;
                week?: string | undefined;
                month?: string | undefined;
                year?: string | undefined;
                days?: string | undefined;
                weeks?: string | undefined;
                seconds?: string | undefined;
                minutes?: string | undefined;
                hours?: string | undefined;
                months?: string | undefined;
                years?: string | undefined;
                quarter?: string | undefined;
                quarters?: string | undefined;
                hour?: string | undefined;
                minute?: string | undefined;
                second?: string | undefined;
            };
            amPm: [string, string];
            monthCache: {
                keys: string[];
                store: Record<string, import("../utils/date/helpers").MonthParts>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
            };
            pageCache: {
                keys: string[];
                store: Record<string, import("../utils/page").CachedPage>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                get: (...args: any[]) => import("../utils/page").CachedPage;
                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
            };
            formatDate: (date: Date, masks: string | string[]) => string;
            parseDate: (dateString: string, mask: string | string[]) => Date;
            toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
            toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
            range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
            getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
            getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getHourLabels: () => string[];
            getDayId: (date: Date) => string;
        };
        dayIndex: number;
        day: number;
        dayFromEnd: number;
        weekday: number;
        weekdayOrdinal: number;
        weekdayOrdinalFromEnd: number;
        week: number;
        weekFromEnd: number;
        weeknumber: number;
        month: number;
        year: number;
        date: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
    }[]>;
    weeks: import("vue").ComputedRef<{
        id: string;
        week: number;
        weekPosition: number;
        weeknumber: number;
        isoWeeknumber: number;
        weeknumberDisplay?: number | undefined;
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        title: string;
    }[]>;
    removeEvent: (event: Event) => void;
    onDayNumberClick(day: CalendarDay): void;
    onGridEscapeKeydown(): void;
    onGridMouseDown(event: MouseEvent): void;
    onEventMouseDown(event: MouseEvent, evt: Event): void;
    onEventResizeStartMouseDown(event: MouseEvent, evt: Event): void;
    onEventResizeEndMouseDown(event: MouseEvent, evt: Event): void;
    onGridTouchStart(event: TouchEvent): void;
    onGridTouchMove(event: TouchEvent): void;
    onGridTouchEnd(event: TouchEvent): void;
    onEventTouchStart(event: TouchEvent, evt: Event): void;
    onEventTouchMove(event: TouchEvent, evt: Event): void;
    onEventTouchEnd(event: TouchEvent, evt: Event): void;
    onEventResizeStartTouchStart(event: TouchEvent, evt: Event): void;
    onEventResizeEndTouchStart(event: TouchEvent, evt: Event): void;
    emit: ((event: string, ...args: any[]) => void) | ((event: string, ...args: any[]) => void);
    containerRef: import("vue").Ref<{
        querySelector: {
            <K extends keyof HTMLElementTagNameMap>(selectors: K): HTMLElementTagNameMap[K] | null;
            <K_1 extends keyof SVGElementTagNameMap>(selectors: K_1): SVGElementTagNameMap[K_1] | null;
            <E extends Element = Element>(selectors: string): E | null;
        };
        addEventListener: Function;
        removeEventListener: Function;
        dispatchEvent: Function;
    } | null>;
    focusedDay: import("vue").Ref<{
        id: string;
        position: number;
        label: string;
        ariaLabel: string;
        weekdayPosition: number;
        weekdayPositionFromEnd: number;
        weekPosition: number;
        isoWeeknumber: number;
        startDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        noonDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        endDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        isToday: boolean;
        isFirstDay: boolean;
        isLastDay: boolean;
        isDisabled: boolean;
        isFocusable: boolean;
        isFocused: boolean;
        inMonth: boolean;
        inPrevMonth: boolean;
        inNextMonth: boolean;
        onTop: boolean;
        onBottom: boolean;
        onLeft: boolean;
        onRight: boolean;
        classes: (string | Object)[];
        locale: {
            id: any;
            daysInWeek: number;
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            masks: any;
            timezone: string | undefined;
            hourLabels: string[];
            dayNames: string[];
            dayNamesShort: string[];
            dayNamesShorter: string[];
            dayNamesNarrow: string[];
            monthNames: string[];
            monthNamesShort: string[];
            relativeTimeNames: {
                day?: string | undefined;
                week?: string | undefined;
                month?: string | undefined;
                year?: string | undefined;
                days?: string | undefined;
                weeks?: string | undefined;
                seconds?: string | undefined;
                minutes?: string | undefined;
                hours?: string | undefined;
                months?: string | undefined;
                years?: string | undefined;
                quarter?: string | undefined;
                quarters?: string | undefined;
                hour?: string | undefined;
                minute?: string | undefined;
                second?: string | undefined;
            };
            amPm: [string, string];
            monthCache: {
                keys: string[];
                store: Record<string, import("../utils/date/helpers").MonthParts>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
            };
            pageCache: {
                keys: string[];
                store: Record<string, import("../utils/page").CachedPage>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                get: (...args: any[]) => import("../utils/page").CachedPage;
                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
            };
            formatDate: (date: Date, masks: string | string[]) => string;
            parseDate: (dateString: string, mask: string | string[]) => Date;
            toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
            toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
            range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
            getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
            getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getHourLabels: () => string[];
            getDayId: (date: Date) => string;
        };
        dayIndex: number;
        day: number;
        dayFromEnd: number;
        weekday: number;
        weekdayOrdinal: number;
        weekdayOrdinalFromEnd: number;
        week: number;
        weekFromEnd: number;
        weeknumber: number;
        month: number;
        year: number;
        date: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
    } | null>;
    inTransition: import("vue").Ref<boolean>;
    navPopoverId: import("vue").Ref<symbol>;
    dayPopoverId: import("vue").Ref<symbol>;
    view: import("vue").Ref<import("./calendar").CalendarView>;
    pages: import("vue").Ref<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: import("../utils/page").TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    }[]>;
    transitionName: import("vue").Ref<string>;
    theme: import("vue").ComputedRef<import("../utils/theme").Theme>;
    color: import("vue").ComputedRef<string>;
    displayMode: import("vue").ComputedRef<"light" | "dark">;
    locale: import("vue").ComputedRef<import("../utils/locale").default>;
    masks: import("vue").ComputedRef<any>;
    attributes: import("vue").ComputedRef<import("../utils/attribute").Attribute[]>;
    disabledAttribute: import("vue").ComputedRef<import("../utils/attribute").Attribute>;
    disabledDates: import("vue").ComputedRef<DateRange[]>;
    attributeContext: import("vue").ComputedRef<DateRangeContext>;
    dayCells: import("vue").ComputedRef<import("./calendar").DayCells>;
    count: import("vue").ComputedRef<number>;
    step: import("vue").ComputedRef<number>;
    firstPage: import("vue").ComputedRef<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: import("../utils/page").TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    } | null>;
    lastPage: import("vue").ComputedRef<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: import("../utils/page").TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    } | null>;
    canMovePrev: import("vue").ComputedRef<boolean>;
    canMoveNext: import("vue").ComputedRef<boolean>;
    minPage: import("vue").ComputedRef<import("../utils/page").PageAddress | null>;
    maxPage: import("vue").ComputedRef<import("../utils/page").PageAddress | null>;
    isMonthly: import("vue").ComputedRef<boolean>;
    isWeekly: import("vue").ComputedRef<boolean>;
    isDaily: import("vue").ComputedRef<boolean>;
    navVisibility: import("vue").ComputedRef<import("../utils/popovers").PopoverVisibility>;
    showWeeknumbers: import("vue").ComputedRef<boolean>;
    showIsoWeeknumbers: import("vue").ComputedRef<boolean>;
    getDateAddress: (date: import("../utils/date/helpers").DateSource) => import("../utils/page").PageAddress;
    canMove: (target: import("./calendar").MoveTarget, opts?: Partial<import("./calendar").MoveOptions>) => boolean;
    canMoveBy: (pages: number, opts?: Partial<import("./calendar").MoveOptions>) => boolean;
    move: (target: import("./calendar").MoveTarget, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
    moveBy: (pages: number, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
    movePrev: () => Promise<boolean>;
    moveNext: () => Promise<boolean>;
    onTransitionBeforeEnter: () => void;
    onTransitionAfterEnter: () => void;
    tryFocusDate: (date: Date) => boolean;
    focusDate: (date: Date, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
    onKeydown: (event: KeyboardEvent) => void;
    onDayKeydown: (day: CalendarDay, event: KeyboardEvent) => void;
    onDayClick: (day: CalendarDay, event: MouseEvent) => void;
    onDayMouseenter: (day: CalendarDay, event: MouseEvent) => void;
    onDayMouseleave: (day: CalendarDay, event: MouseEvent) => void;
    onDayFocusin: (day: CalendarDay, event: FocusEvent | null) => void;
    onDayFocusout: (day: CalendarDay, event: FocusEvent) => void;
    onWeeknumberClick: (week: import("../utils/page").CalendarWeek, event: MouseEvent) => void;
};
export declare function useCalendarGrid(): {
    dailyGridRef: import("vue").Ref<{
        getBoundingClientRect: () => DOMRect;
        contains: (other: Node | null) => boolean;
    } | null>;
    weeklyGridRef: import("vue").Ref<{
        getBoundingClientRect: () => DOMRect;
        contains: (other: Node | null) => boolean;
    } | null>;
    cellPopoverRef: import("vue").Ref<import("vue").DefineComponent<{
        popoverId: {
            type: StringConstructor;
            default: string;
        };
    }, {
        displayMode: import("vue").ComputedRef<"light" | "dark">;
        color: import("vue").ComputedRef<string>;
        show: (event: {
            refSelector: string;
            isMultiDay: boolean;
            isWeekly: boolean;
            durationMs: number;
            durationMinutes: number;
            startDate: Date;
            startDateTime: number;
            startTimeLabel: string;
            endDate: Date;
            endDateTime: number;
            endTimeLabel: string;
            timeLabel: string;
            isSolid: boolean;
            dragIsDirty: boolean;
            formatDate: (date: Date, mask: string) => string;
            formatTime: (date: Date) => string;
            resizeToConstraints: () => void;
            startResize: (day: CalendarDay, isStart: boolean) => void;
            updateResize: (offset: ResizeOffset) => void;
            stopResize: () => void;
            startDrag: (day: CalendarDay) => void;
            updateDrag: (offset: DragOffset) => void;
            stopDrag: () => false | undefined;
            compareTo: (b: any) => number;
            key: any;
            summary: string;
            description: string;
            range: DateRange;
            allDay: boolean;
            color: string;
            fill: string;
            selected: boolean;
            draggable: boolean;
            dragging: boolean;
            resizable: boolean;
            resizing: boolean;
            editing: boolean;
            order: number;
            snapMinutes: number;
            minDurationMinutes: number;
            maxDurationMinutes: number;
            popover: Partial<import("../utils/popovers").PopoverOptions> | null;
            resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
            dragOrigin: import("../utils/calendar/event").DragOrigin | null;
        }) => void;
        update: (event: {
            refSelector: string;
            isMultiDay: boolean;
            isWeekly: boolean;
            durationMs: number;
            durationMinutes: number;
            startDate: Date;
            startDateTime: number;
            startTimeLabel: string;
            endDate: Date;
            endDateTime: number;
            endTimeLabel: string;
            timeLabel: string;
            isSolid: boolean;
            dragIsDirty: boolean;
            formatDate: (date: Date, mask: string) => string;
            formatTime: (date: Date) => string;
            resizeToConstraints: () => void;
            startResize: (day: CalendarDay, isStart: boolean) => void;
            updateResize: (offset: ResizeOffset) => void;
            stopResize: () => void;
            startDrag: (day: CalendarDay) => void;
            updateDrag: (offset: DragOffset) => void;
            stopDrag: () => false | undefined;
            compareTo: (b: any) => number;
            key: any;
            summary: string;
            description: string;
            range: DateRange;
            allDay: boolean;
            color: string;
            fill: string;
            selected: boolean;
            draggable: boolean;
            dragging: boolean;
            resizable: boolean;
            resizing: boolean;
            editing: boolean;
            order: number;
            snapMinutes: number;
            minDurationMinutes: number;
            maxDurationMinutes: number;
            popover: Partial<import("../utils/popovers").PopoverOptions> | null;
            resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
            dragOrigin: import("../utils/calendar/event").DragOrigin | null;
        }) => void;
        hide: () => void;
        isVisible: () => boolean;
        onAfterHide(): void;
        event: import("vue").Ref<{
            refSelector: string;
            isMultiDay: boolean;
            isWeekly: boolean;
            durationMs: number;
            durationMinutes: number;
            startDate: Date;
            startDateTime: number;
            startTimeLabel: string;
            endDate: Date;
            endDateTime: number;
            endTimeLabel: string;
            timeLabel: string;
            isSolid: boolean;
            dragIsDirty: boolean;
            formatDate: (date: Date, mask: string) => string;
            formatTime: (date: Date) => string;
            resizeToConstraints: () => void;
            startResize: (day: CalendarDay, isStart: boolean) => void;
            updateResize: (offset: ResizeOffset) => void;
            stopResize: () => void;
            startDrag: (day: CalendarDay) => void;
            updateDrag: (offset: DragOffset) => void;
            stopDrag: () => false | undefined;
            compareTo: (b: any) => number;
            key: any;
            summary: string;
            description: string;
            range: DateRange;
            allDay: boolean;
            color: string;
            fill: string;
            selected: boolean;
            draggable: boolean;
            dragging: boolean;
            resizable: boolean;
            resizing: boolean;
            editing: boolean;
            order: number;
            snapMinutes: number;
            minDurationMinutes: number;
            maxDurationMinutes: number;
            popover: Partial<import("../utils/popovers").PopoverOptions> | null;
            resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
            dragOrigin: import("../utils/calendar/event").DragOrigin | null;
        } | null>;
        popoverRef: import("vue").Ref<null>;
    }, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<ExtractPropTypes<{
        popoverId: {
            type: StringConstructor;
            default: string;
        };
    }>>, {
        popoverId: string;
    }> | undefined>;
    dayColumns: import("vue").ComputedRef<number>;
    dayRows: import("vue").ComputedRef<number>;
    snapMinutes: import("vue").Ref<number>;
    snapMs: import("vue").ComputedRef<number>;
    pixelsPerHour: import("vue").Ref<number>;
    isTouch: import("vue").Ref<boolean>;
    events: import("vue").ComputedRef<{
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }[]>;
    eventsMap: import("vue").Ref<Record<any, {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }>>;
    selectedEvents: import("vue").ComputedRef<{
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }[]>;
    hasSelectedEvents: import("vue").ComputedRef<boolean>;
    eventsContext: import("vue").ComputedRef<DateRangeContext>;
    detailEvent: import("vue").Ref<{
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        startDateTime: number;
        startTimeLabel: string;
        endDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: {
            order: number;
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            start: {
                milliseconds: number;
                seconds: number;
                minutes: number;
                hours: number;
                time: number;
                dateTime: number;
                isValid: boolean;
                timezoneOffset: number;
                isPm?: boolean | undefined;
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            } | null;
            end: {
                milliseconds: number;
                seconds: number;
                minutes: number;
                hours: number;
                time: number;
                dateTime: number;
                isValid: boolean;
                timezoneOffset: number;
                isPm?: boolean | undefined;
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            } | null;
            repeat: {
                validated: boolean;
                config: import("../utils/date/repeat").DateRepeatFn | {
                    every?: import("../utils/date/repeat").RepeatIntervalShort | [number, import("../utils/date/repeat").RepeatInterval] | undefined;
                    from?: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    } | undefined;
                    until?: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    } | undefined;
                    weekdays?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").DayOfWeek> | undefined;
                    days?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").DayInMonth> | undefined;
                    weeks?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").WeekInMonth> | undefined;
                    months?: import("../utils/date/rules").SingleOrArray<import("../utils/date/helpers").MonthInYear> | undefined;
                    years?: import("../utils/date/rules").SingleOrArray<number> | undefined;
                    ordinalWeekdays?: import("../utils/date/rules").SingleOrArray<number[]> | undefined;
                    on?: import("../utils/date/repeat").DateRepeatFn | any | (import("../utils/date/repeat").DateRepeatFn | any)[] | undefined;
                };
                type: import("../utils/date/rules").GroupRuleType;
                from: {
                    milliseconds: number;
                    seconds: number;
                    minutes: number;
                    hours: number;
                    time: number;
                    dateTime: number;
                    isValid: boolean;
                    timezoneOffset: number;
                    isPm?: boolean | undefined;
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                } | undefined;
                until: {
                    milliseconds: number;
                    seconds: number;
                    minutes: number;
                    hours: number;
                    time: number;
                    dateTime: number;
                    isValid: boolean;
                    timezoneOffset: number;
                    isPm?: boolean | undefined;
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                } | undefined;
                rules: {
                    type: import("../utils/date/rules").RuleType;
                    passes: (dayParts: import("../utils/date/helpers").DayParts) => boolean;
                }[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                getObjectRules: (config: any) => import("../utils/date/rules").Rule<import("../utils/date/rules").RuleType>[];
                passes: (dayParts: import("../utils/date/helpers").DayParts) => boolean;
            } | null;
            readonly opts: {
                order: number;
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
            };
            readonly hasRepeat: boolean;
            readonly isSingleDay: boolean | null;
            readonly isMultiDay: boolean;
            readonly daySpan: number;
            startsOnDay: (dayParts: import("../utils/date/helpers").DayParts) => boolean;
            intersectsDay: (dayIndex: number) => boolean;
            intersectsRange: (range: DateRange) => boolean;
            intersectsDayRange: (startDayIndex: number, endDayIndex: number) => boolean;
        };
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: {
            id?: PropertyKey | undefined;
            visibility?: import("../utils/popovers").PopoverVisibility | undefined;
            isInteractive?: boolean | undefined;
            autoHide?: boolean | undefined;
            force?: boolean | undefined;
            target?: unknown;
            placement?: import("@popperjs/core").Placement | undefined;
            modifiers?: any;
            data?: any;
            showDelay?: number | undefined;
            hideDelay?: number | undefined;
        } | null;
        resizeOrigin: {
            start: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            end: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isStart: boolean;
        } | null;
        dragOrigin: {
            day: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            };
            start: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            end: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            minOffsetWeeks: number;
            maxOffsetWeeks: number;
            minOffsetWeekdays: number;
            maxOffsetWeekdays: number;
            minOffsetMs: number;
            maxOffsetMs: number;
            durationMs: number;
        } | null;
    } | null>;
    resizing: import("vue").Ref<boolean>;
    dragging: import("vue").Ref<boolean>;
    gridStyle: import("vue").ComputedRef<{
        height: string;
    }>;
    fill: import("vue").Ref<string>;
    page: import("vue").ComputedRef<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: import("../utils/page").TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    }>;
    days: import("vue").ComputedRef<{
        id: string;
        position: number;
        label: string;
        ariaLabel: string;
        weekdayPosition: number;
        weekdayPositionFromEnd: number;
        weekPosition: number;
        isoWeeknumber: number;
        startDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        noonDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        endDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        isToday: boolean;
        isFirstDay: boolean;
        isLastDay: boolean;
        isDisabled: boolean;
        isFocusable: boolean;
        isFocused: boolean;
        inMonth: boolean;
        inPrevMonth: boolean;
        inNextMonth: boolean;
        onTop: boolean;
        onBottom: boolean;
        onLeft: boolean;
        onRight: boolean;
        classes: (string | Object)[];
        locale: {
            id: any;
            daysInWeek: number;
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            masks: any;
            timezone: string | undefined;
            hourLabels: string[];
            dayNames: string[];
            dayNamesShort: string[];
            dayNamesShorter: string[];
            dayNamesNarrow: string[];
            monthNames: string[];
            monthNamesShort: string[];
            relativeTimeNames: {
                day?: string | undefined;
                week?: string | undefined;
                month?: string | undefined;
                year?: string | undefined;
                days?: string | undefined;
                weeks?: string | undefined;
                seconds?: string | undefined;
                minutes?: string | undefined;
                hours?: string | undefined;
                months?: string | undefined;
                years?: string | undefined;
                quarter?: string | undefined;
                quarters?: string | undefined;
                hour?: string | undefined;
                minute?: string | undefined;
                second?: string | undefined;
            };
            amPm: [string, string];
            monthCache: {
                keys: string[];
                store: Record<string, import("../utils/date/helpers").MonthParts>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
            };
            pageCache: {
                keys: string[];
                store: Record<string, import("../utils/page").CachedPage>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                get: (...args: any[]) => import("../utils/page").CachedPage;
                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
            };
            formatDate: (date: Date, masks: string | string[]) => string;
            parseDate: (dateString: string, mask: string | string[]) => Date;
            toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
            toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
            range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
            getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
            getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getHourLabels: () => string[];
            getDayId: (date: Date) => string;
        };
        dayIndex: number;
        day: number;
        dayFromEnd: number;
        weekday: number;
        weekdayOrdinal: number;
        weekdayOrdinalFromEnd: number;
        week: number;
        weekFromEnd: number;
        weeknumber: number;
        month: number;
        year: number;
        date: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
    }[]>;
    weeks: import("vue").ComputedRef<{
        id: string;
        week: number;
        weekPosition: number;
        weeknumber: number;
        isoWeeknumber: number;
        weeknumberDisplay?: number | undefined;
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        title: string;
    }[]>;
    removeEvent: (event: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }) => void;
    onDayNumberClick(day: CalendarDay): void;
    onGridEscapeKeydown(): void;
    onGridMouseDown(event: MouseEvent): void;
    onEventMouseDown(event: MouseEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    onEventResizeStartMouseDown(event: MouseEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    onEventResizeEndMouseDown(event: MouseEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    onGridTouchStart(event: TouchEvent): void;
    onGridTouchMove(event: TouchEvent): void;
    onGridTouchEnd(event: TouchEvent): void;
    onEventTouchStart(event: TouchEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    onEventTouchMove(event: TouchEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    onEventTouchEnd(event: TouchEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    onEventResizeStartTouchStart(event: TouchEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    onEventResizeEndTouchStart(event: TouchEvent, evt: {
        refSelector: string;
        isMultiDay: boolean;
        isWeekly: boolean;
        durationMs: number;
        durationMinutes: number;
        startDate: Date;
        startDateTime: number;
        startTimeLabel: string;
        endDate: Date;
        endDateTime: number;
        endTimeLabel: string;
        timeLabel: string;
        isSolid: boolean;
        dragIsDirty: boolean;
        formatDate: (date: Date, mask: string) => string;
        formatTime: (date: Date) => string;
        resizeToConstraints: () => void;
        startResize: (day: CalendarDay, isStart: boolean) => void;
        updateResize: (offset: ResizeOffset) => void;
        stopResize: () => void;
        startDrag: (day: CalendarDay) => void;
        updateDrag: (offset: DragOffset) => void;
        stopDrag: () => false | undefined;
        compareTo: (b: any) => number;
        key: any;
        summary: string;
        description: string;
        range: DateRange;
        allDay: boolean;
        color: string;
        fill: string;
        selected: boolean;
        draggable: boolean;
        dragging: boolean;
        resizable: boolean;
        resizing: boolean;
        editing: boolean;
        order: number;
        snapMinutes: number;
        minDurationMinutes: number;
        maxDurationMinutes: number;
        popover: Partial<import("../utils/popovers").PopoverOptions> | null;
        resizeOrigin: import("../utils/calendar/event").ResizeOrigin | null;
        dragOrigin: import("../utils/calendar/event").DragOrigin | null;
    }): void;
    emit: ((event: string, ...args: any[]) => void) | ((event: string, ...args: any[]) => void);
    containerRef: import("vue").Ref<{
        querySelector: {
            <K extends keyof HTMLElementTagNameMap>(selectors: K): HTMLElementTagNameMap[K] | null;
            <K_1 extends keyof SVGElementTagNameMap>(selectors: K_1): SVGElementTagNameMap[K_1] | null;
            <E extends Element = Element>(selectors: string): E | null;
        };
        addEventListener: Function;
        removeEventListener: Function;
        dispatchEvent: Function;
    } | null>;
    focusedDay: import("vue").Ref<{
        id: string;
        position: number;
        label: string;
        ariaLabel: string;
        weekdayPosition: number;
        weekdayPositionFromEnd: number;
        weekPosition: number;
        isoWeeknumber: number;
        startDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        noonDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        endDate: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
        isToday: boolean;
        isFirstDay: boolean;
        isLastDay: boolean;
        isDisabled: boolean;
        isFocusable: boolean;
        isFocused: boolean;
        inMonth: boolean;
        inPrevMonth: boolean;
        inNextMonth: boolean;
        onTop: boolean;
        onBottom: boolean;
        onLeft: boolean;
        onRight: boolean;
        classes: (string | Object)[];
        locale: {
            id: any;
            daysInWeek: number;
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            masks: any;
            timezone: string | undefined;
            hourLabels: string[];
            dayNames: string[];
            dayNamesShort: string[];
            dayNamesShorter: string[];
            dayNamesNarrow: string[];
            monthNames: string[];
            monthNamesShort: string[];
            relativeTimeNames: {
                day?: string | undefined;
                week?: string | undefined;
                month?: string | undefined;
                year?: string | undefined;
                days?: string | undefined;
                weeks?: string | undefined;
                seconds?: string | undefined;
                minutes?: string | undefined;
                hours?: string | undefined;
                months?: string | undefined;
                years?: string | undefined;
                quarter?: string | undefined;
                quarters?: string | undefined;
                hour?: string | undefined;
                minute?: string | undefined;
                second?: string | undefined;
            };
            amPm: [string, string];
            monthCache: {
                keys: string[];
                store: Record<string, import("../utils/date/helpers").MonthParts>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
            };
            pageCache: {
                keys: string[];
                store: Record<string, import("../utils/page").CachedPage>;
                size: number;
                createKey: (...args: any[]) => string;
                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                get: (...args: any[]) => import("../utils/page").CachedPage;
                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
            };
            formatDate: (date: Date, masks: string | string[]) => string;
            parseDate: (dateString: string, mask: string | string[]) => Date;
            toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
            toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
            range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
            getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
            getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
            getHourLabels: () => string[];
            getDayId: (date: Date) => string;
        };
        dayIndex: number;
        day: number;
        dayFromEnd: number;
        weekday: number;
        weekdayOrdinal: number;
        weekdayOrdinalFromEnd: number;
        week: number;
        weekFromEnd: number;
        weeknumber: number;
        month: number;
        year: number;
        date: {
            toString: () => string;
            toDateString: () => string;
            toTimeString: () => string;
            toLocaleString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleDateString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            toLocaleTimeString: {
                (): string;
                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
            };
            valueOf: () => number;
            getTime: () => number;
            getFullYear: () => number;
            getUTCFullYear: () => number;
            getMonth: () => number;
            getUTCMonth: () => number;
            getDate: () => number;
            getUTCDate: () => number;
            getDay: () => number;
            getUTCDay: () => number;
            getHours: () => number;
            getUTCHours: () => number;
            getMinutes: () => number;
            getUTCMinutes: () => number;
            getSeconds: () => number;
            getUTCSeconds: () => number;
            getMilliseconds: () => number;
            getUTCMilliseconds: () => number;
            getTimezoneOffset: () => number;
            setTime: (time: number) => number;
            setMilliseconds: (ms: number) => number;
            setUTCMilliseconds: (ms: number) => number;
            setSeconds: (sec: number, ms?: number | undefined) => number;
            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
            setDate: (date: number) => number;
            setUTCDate: (date: number) => number;
            setMonth: (month: number, date?: number | undefined) => number;
            setUTCMonth: (month: number, date?: number | undefined) => number;
            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
            toUTCString: () => string;
            toISOString: () => string;
            toJSON: (key?: any) => string;
            getVarDate: () => VarDate;
            [Symbol.toPrimitive]: {
                (hint: "default"): string;
                (hint: "string"): string;
                (hint: "number"): number;
                (hint: string): string | number;
            };
        };
    } | null>;
    inTransition: import("vue").Ref<boolean>;
    navPopoverId: import("vue").Ref<symbol>;
    dayPopoverId: import("vue").Ref<symbol>;
    view: import("vue").Ref<import("./calendar").CalendarView>;
    pages: import("vue").Ref<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: import("../utils/page").TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        viewWeeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
    }[]>;
    transitionName: import("vue").Ref<string>;
    theme: import("vue").ComputedRef<import("../utils/theme").Theme>;
    color: import("vue").ComputedRef<string>;
    displayMode: import("vue").ComputedRef<"light" | "dark">;
    locale: import("vue").ComputedRef<import("../utils/locale").default>;
    masks: import("vue").ComputedRef<any>;
    attributes: import("vue").ComputedRef<import("../utils/attribute").Attribute[]>;
    disabledAttribute: import("vue").ComputedRef<import("../utils/attribute").Attribute>;
    disabledDates: import("vue").ComputedRef<DateRange[]>;
    attributeContext: import("vue").ComputedRef<DateRangeContext>;
    dayCells: import("vue").ComputedRef<import("./calendar").DayCells>;
    count: import("vue").ComputedRef<number>;
    step: import("vue").ComputedRef<number>;
    firstPage: import("vue").ComputedRef<{
        id: string;
        day?: number | undefined;
        week?: number | undefined;
        month: number;
        year: number;
        view: import("../utils/page").PageView;
        trimWeeks: boolean;
        position: number;
        row: number;
        rowFromEnd: number;
        column: number;
        columnFromEnd: number;
        showWeeknumbers: boolean;
        showIsoWeeknumbers: boolean;
        weeknumberPosition: string;
        monthTitle: string;
        weekTitle?: string | undefined;
        dayTitle?: string | undefined;
        title: string;
        titlePosition: import("../utils/page").TitlePosition;
        shortMonthLabel: string;
        monthLabel: string;
        shortYearLabel: string;
        yearLabel: string;
        monthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        prevMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        nextMonthComps: {
            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
            firstDayOfMonth: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            inLeapYear: boolean;
            firstWeekday: number;
            numDays: number;
            numWeeks: number;
            month: number;
            year: number;
            weeknumbers: number[];
            isoWeeknumbers: number[];
        };
        days: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        }[];
        weeks: {
            id: string;
            week: number;
            weekPosition: number;
            weeknumber: number;
            isoWeeknumber: number;
            weeknumberDisplay?: number | undefined;
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                    getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                    getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            title: string;
        }[];
        weekdays: {
            weekday: number;
            label: string;
        }[];
        viewDays: {
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<import("../utils/date/helpers").SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | import("../utils/date/helpers").DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => DateRange[];
                getDateParts: (date: Date) => import("../utils/date/helpers").DateParts;
                getDateFromParts: (parts: Partial<import("../utils/date/helpers").SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "num