import { type DateParts, type SimpleDateParts } from '../utils/date/helpers';
export interface TimePickerProps {
    position: number;
}
export type TimePickerContext = ReturnType<typeof createTimePicker>;
export declare function createTimePicker(props: TimePickerProps): {
    showHeader: import("vue").ComputedRef<boolean>;
    timeAccuracy: import("vue").Ref<number>;
    parts: import("vue").ComputedRef<DateParts | {
        isValid: boolean;
    }>;
    isValid: import("vue").ComputedRef<boolean>;
    date: import("vue").ComputedRef<Date | null>;
    hours: import("vue").WritableComputedRef<number>;
    minutes: import("vue").WritableComputedRef<number>;
    seconds: import("vue").WritableComputedRef<number>;
    milliseconds: import("vue").WritableComputedRef<number>;
    options: import("vue").ComputedRef<{
        milliseconds: import("../utils/date/helpers").DatePartOption[];
        seconds: import("../utils/date/helpers").DatePartOption[];
        minutes: import("../utils/date/helpers").DatePartOption[];
        hours: import("../utils/date/helpers").DatePartOption[];
    }>;
    hourOptions: import("vue").ComputedRef<{
        value: number;
        label: string;
    }[]>;
    isAM: import("vue").WritableComputedRef<boolean>;
    isAMOptions: import("vue").ComputedRef<{
        value: boolean;
        label: string;
    }[]>;
    is24hr: import("vue").Ref<boolean>;
    showCalendar: import("vue").Ref<boolean>;
    datePickerPopoverId: import("vue").Ref<symbol>;
    popoverRef: import("vue").Ref<({
        $: import("vue").ComponentInternalInstance;
        $data: {};
        $props: Partial<{
            showDelay: number;
            hideDelay: number;
        }> & Omit<Readonly<import("vue").ExtractPropTypes<{
            id: {
                type: (SymbolConstructor | StringConstructor | NumberConstructor)[];
                required: true;
            };
            showDelay: {
                type: NumberConstructor;
                default: number;
            };
            hideDelay: {
                type: NumberConstructor;
                default: number;
            };
            boundarySelector: {
                type: StringConstructor;
            };
        }>> & {
            "onBefore-show"?: ((...args: any[]) => any) | undefined;
            "onAfter-show"?: ((...args: any[]) => any) | undefined;
            "onBefore-hide"?: ((...args: any[]) => any) | undefined;
            "onAfter-hide"?: ((...args: any[]) => any) | undefined;
        } & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, "showDelay" | "hideDelay">;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            [name: string]: import("vue").Slot | undefined;
        }>;
        $root: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null;
        $parent: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null;
        $emit: (event: "before-show" | "after-show" | "before-hide" | "after-hide", ...args: any[]) => void;
        $el: any;
        $options: import("vue").ComponentOptionsBase<Readonly<import("vue").ExtractPropTypes<{
            id: {
                type: (SymbolConstructor | StringConstructor | NumberConstructor)[];
                required: true;
            };
            showDelay: {
                type: NumberConstructor;
                default: number;
            };
            hideDelay: {
                type: NumberConstructor;
                default: number;
            };
            boundarySelector: {
                type: StringConstructor;
            };
        }>> & {
            "onBefore-show"?: ((...args: any[]) => any) | undefined;
            "onAfter-show"?: ((...args: any[]) => any) | undefined;
            "onBefore-hide"?: ((...args: any[]) => any) | undefined;
            "onAfter-hide"?: ((...args: any[]) => any) | undefined;
        }, {
            popoverRef: import("vue").Ref<HTMLElement | undefined>;
            alignment: import("vue").ComputedRef<"center" | "left" | "right" | "top" | "bottom" | "middle">;
            hide: (opts?: Partial<import("../utils/popovers").PopoverOptions>) => void;
            setupPopper: () => void;
            beforeEnter: (el: Element) => void;
            afterEnter: (el: Element) => void;
            beforeLeave: (el: Element) => void;
            afterLeave: (el: Element) => void;
            onClick: (e: MouseEvent) => void;
            onMouseOver: () => void;
            onMouseLeave: () => void;
            onFocusIn: () => void;
            onFocusOut: (e: FocusEvent) => void;
            isVisible: import("vue").Ref<boolean>;
            target: import("vue").Ref<unknown>;
            data: import("vue").Ref<any>;
            transition: import("vue").Ref<string>;
            placement: import("vue").Ref<import("@popperjs/core").Placement>;
            direction: import("vue").Ref<string>;
            positionFixed: import("vue").Ref<false>;
            modifiers: import("vue").Ref<any[]>;
            isInteractive: import("vue").Ref<boolean>;
            visibility: import("vue").Ref<import("../utils/popovers").PopoverVisibility>;
            isHovered: import("vue").Ref<boolean>;
            isFocused: import("vue").Ref<boolean>;
            autoHide: import("vue").Ref<boolean>;
            force: import("vue").Ref<boolean>;
        }, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, ("before-show" | "after-show" | "before-hide" | "after-hide")[], string, {
            showDelay: number;
            hideDelay: number;
        }, {}, string> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof import("vue").nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: import("vue").WatchOptions<boolean> | undefined): import("vue").WatchStopHandle;
    } & Readonly<import("vue").ExtractPropTypes<{
        id: {
            type: (SymbolConstructor | StringConstructor | NumberConstructor)[];
            required: true;
        };
        showDelay: {
            type: NumberConstructor;
            default: number;
        };
        hideDelay: {
            type: NumberConstructor;
            default: number;
        };
        boundarySelector: {
            type: StringConstructor;
        };
    }>> & {
        "onBefore-show"?: ((...args: any[]) => any) | undefined;
        "onAfter-show"?: ((...args: any[]) => any) | undefined;
        "onBefore-hide"?: ((...args: any[]) => any) | undefined;
        "onAfter-hide"?: ((...args: any[]) => any) | undefined;
    } & import("vue").ShallowUnwrapRef<{
        popoverRef: import("vue").Ref<HTMLElement | undefined>;
        alignment: import("vue").ComputedRef<"center" | "left" | "right" | "top" | "bottom" | "middle">;
        hide: (opts?: Partial<import("../utils/popovers").PopoverOptions>) => void;
        setupPopper: () => void;
        beforeEnter: (el: Element) => void;
        afterEnter: (el: Element) => void;
        beforeLeave: (el: Element) => void;
        afterLeave: (el: Element) => void;
        onClick: (e: MouseEvent) => void;
        onMouseOver: () => void;
        onMouseLeave: () => void;
        onFocusIn: () => void;
        onFocusOut: (e: FocusEvent) => void;
        isVisible: import("vue").Ref<boolean>;
        target: import("vue").Ref<unknown>;
        data: import("vue").Ref<any>;
        transition: import("vue").Ref<string>;
        placement: import("vue").Ref<import("@popperjs/core").Placement>;
        direction: import("vue").Ref<string>;
        positionFixed: import("vue").Ref<false>;
        modifiers: import("vue").Ref<any[]>;
        isInteractive: import("vue").Ref<boolean>;
        visibility: import("vue").Ref<import("../utils/popovers").PopoverVisibility>;
        isHovered: import("vue").Ref<boolean>;
        isFocused: import("vue").Ref<boolean>;
        autoHide: import("vue").Ref<boolean>;
        force: import("vue").Ref<boolean>;
    }> & {} & import("vue").ComponentCustomProperties & {}) | null>;
    popoverEvents: import("vue").ComputedRef<Partial<import("../utils/popovers").PopoverEventHandlers>>;
    calendarRef: import("vue").Ref<({
        $: import("vue").ComponentInternalInstance;
        $data: {};
        $props: Partial<{
            view: import("./calendar").CalendarView;
            trimWeeks: boolean;
            titlePosition: import("../utils/page").TitlePosition;
            color: string;
            isDark: boolean | "system" | import("vue-screen-utils").DarkModeClassConfig;
            navVisibility: import("../utils/popovers").PopoverVisibility;
            rows: number;
            columns: number;
            expanded: boolean;
            borderless: boolean;
            transparent: boolean;
            initialPagePosition: number;
            disablePageSwipe: boolean;
        }> & Omit<Readonly<import("vue").ExtractPropTypes<{
            view: {
                type: import("vue").PropType<import("./calendar").CalendarView>;
                default: string;
                validator(value: string): boolean;
            };
            rows: {
                type: NumberConstructor;
                default: number;
            };
            columns: {
                type: NumberConstructor;
                default: number;
            };
            step: NumberConstructor;
            titlePosition: {
                type: import("vue").PropType<import("../utils/page").TitlePosition>;
                default: () => import("../utils/page").TitlePosition;
            };
            navVisibility: {
                type: import("vue").PropType<import("../utils/popovers").PopoverVisibility>;
                default: () => import("../utils/popovers").PopoverVisibility;
            };
            showWeeknumbers: (BooleanConstructor | StringConstructor)[];
            showIsoWeeknumbers: (BooleanConstructor | StringConstructor)[];
            expanded: BooleanConstructor;
            borderless: BooleanConstructor;
            transparent: BooleanConstructor;
            initialPage: import("vue").PropType<import("../utils/page").PageAddress>;
            initialPagePosition: {
                type: NumberConstructor;
                default: number;
            };
            minPage: import("vue").PropType<import("../utils/page").PageAddress>;
            maxPage: import("vue").PropType<import("../utils/page").PageAddress>;
            transition: import("vue").PropType<import("./calendar").MoveTransition>;
            attributes: import("vue").PropType<Partial<{
                key: string | number;
                hashcode: string;
                content: import("../utils/glyph").ContentConfig;
                highlight: import("../utils/glyph").HighlightConfig;
                dot: import("../utils/glyph").DotConfig;
                bar: import("../utils/glyph").BarConfig;
                popover: Partial<{
                    label: string;
                    visibility: import("../utils/popovers").PopoverVisibility;
                    placement: import("@popperjs/core").Placement;
                    hideIndicator: boolean;
                    isInteractive: boolean;
                }>;
                event: Partial<{
                    label: string;
                }>;
                dates: import("../utils/date/range").DateRangeSource[];
                customData: any;
                order: number;
                pinPage: boolean;
            }>[]>;
            trimWeeks: BooleanConstructor;
            disablePageSwipe: BooleanConstructor;
            color: {
                type: StringConstructor;
                default: () => any;
            };
            isDark: {
                type: import("vue").PropType<boolean | "system" | import("vue-screen-utils").DarkModeClassConfig>;
                default: () => any;
            };
            firstDayOfWeek: import("vue").PropType<import("../utils/date/helpers").DayOfWeek>;
            masks: ObjectConstructor;
            locale: import("vue").PropType<string | import("../utils/locale").default | Record<string, any>>;
            timezone: StringConstructor;
            minDate: null;
            maxDate: null;
            disabledDates: null;
        }>> & import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, "view" | "trimWeeks" | "titlePosition" | "color" | "isDark" | "navVisibility" | "rows" | "columns" | "expanded" | "borderless" | "transparent" | "initialPagePosition" | "disablePageSwipe">;
        $attrs: {
            [x: string]: unknown;
        };
        $refs: {
            [x: string]: unknown;
        };
        $slots: Readonly<{
            [name: string]: import("vue").Slot | undefined;
        }>;
        $root: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null;
        $parent: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null;
        $emit: (event: string, ...args: any[]) => void;
        $el: any;
        $options: import("vue").ComponentOptionsBase<Readonly<import("vue").ExtractPropTypes<{
            view: {
                type: import("vue").PropType<import("./calendar").CalendarView>;
                default: string;
                validator(value: string): boolean;
            };
            rows: {
                type: NumberConstructor;
                default: number;
            };
            columns: {
                type: NumberConstructor;
                default: number;
            };
            step: NumberConstructor;
            titlePosition: {
                type: import("vue").PropType<import("../utils/page").TitlePosition>;
                default: () => import("../utils/page").TitlePosition;
            };
            navVisibility: {
                type: import("vue").PropType<import("../utils/popovers").PopoverVisibility>;
                default: () => import("../utils/popovers").PopoverVisibility;
            };
            showWeeknumbers: (BooleanConstructor | StringConstructor)[];
            showIsoWeeknumbers: (BooleanConstructor | StringConstructor)[];
            expanded: BooleanConstructor;
            borderless: BooleanConstructor;
            transparent: BooleanConstructor;
            initialPage: import("vue").PropType<import("../utils/page").PageAddress>;
            initialPagePosition: {
                type: NumberConstructor;
                default: number;
            };
            minPage: import("vue").PropType<import("../utils/page").PageAddress>;
            maxPage: import("vue").PropType<import("../utils/page").PageAddress>;
            transition: import("vue").PropType<import("./calendar").MoveTransition>;
            attributes: import("vue").PropType<Partial<{
                key: string | number;
                hashcode: string;
                content: import("../utils/glyph").ContentConfig;
                highlight: import("../utils/glyph").HighlightConfig;
                dot: import("../utils/glyph").DotConfig;
                bar: import("../utils/glyph").BarConfig;
                popover: Partial<{
                    label: string;
                    visibility: import("../utils/popovers").PopoverVisibility;
                    placement: import("@popperjs/core").Placement;
                    hideIndicator: boolean;
                    isInteractive: boolean;
                }>;
                event: Partial<{
                    label: string;
                }>;
                dates: import("../utils/date/range").DateRangeSource[];
                customData: any;
                order: number;
                pinPage: boolean;
            }>[]>;
            trimWeeks: BooleanConstructor;
            disablePageSwipe: BooleanConstructor;
            color: {
                type: StringConstructor;
                default: () => any;
            };
            isDark: {
                type: import("vue").PropType<boolean | "system" | import("vue-screen-utils").DarkModeClassConfig>;
                default: () => any;
            };
            firstDayOfWeek: import("vue").PropType<import("../utils/date/helpers").DayOfWeek>;
            masks: ObjectConstructor;
            locale: import("vue").PropType<string | import("../utils/locale").default | Record<string, any>>;
            timezone: StringConstructor;
            minDate: null;
            maxDate: null;
            disabledDates: null;
        }>>, {
            emit: ((event: string, ...args: any[]) => void) | ((event: string, ...args: any[]) => void);
            containerRef: import("vue").Ref<{
                querySelector: {
                    <K extends keyof HTMLElementTagNameMap>(selectors: K): HTMLElementTagNameMap[K] | null;
                    <K_1 extends keyof SVGElementTagNameMap>(selectors: K_1): SVGElementTagNameMap[K_1] | null;
                    <E extends Element = Element>(selectors: string): E | null;
                };
                addEventListener: Function;
                removeEventListener: Function;
                dispatchEvent: Function;
            } | null>;
            focusedDay: import("vue").Ref<{
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => DateParts;
                    getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            } | null>;
            inTransition: import("vue").Ref<boolean>;
            navPopoverId: import("vue").Ref<symbol>;
            dayPopoverId: import("vue").Ref<symbol>;
            view: import("vue").Ref<import("./calendar").CalendarView>;
            pages: import("vue").Ref<{
                id: string;
                day?: number | undefined;
                week?: number | undefined;
                month: number;
                year: number;
                view: import("../utils/page").PageView;
                trimWeeks: boolean;
                position: number;
                row: number;
                rowFromEnd: number;
                column: number;
                columnFromEnd: number;
                showWeeknumbers: boolean;
                showIsoWeeknumbers: boolean;
                weeknumberPosition: string;
                monthTitle: string;
                weekTitle?: string | undefined;
                dayTitle?: string | undefined;
                title: string;
                titlePosition: import("../utils/page").TitlePosition;
                shortMonthLabel: string;
                monthLabel: string;
                shortYearLabel: string;
                yearLabel: string;
                monthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                prevMonthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                nextMonthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                weeks: {
                    id: string;
                    week: number;
                    weekPosition: number;
                    weeknumber: number;
                    isoWeeknumber: number;
                    weeknumberDisplay?: number | undefined;
                    days: {
                        id: string;
                        position: number;
                        label: string;
                        ariaLabel: string;
                        weekdayPosition: number;
                        weekdayPositionFromEnd: number;
                        weekPosition: number;
                        isoWeeknumber: number;
                        startDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        noonDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        endDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        isToday: boolean;
                        isFirstDay: boolean;
                        isLastDay: boolean;
                        isDisabled: boolean;
                        isFocusable: boolean;
                        isFocused: boolean;
                        inMonth: boolean;
                        inPrevMonth: boolean;
                        inNextMonth: boolean;
                        onTop: boolean;
                        onBottom: boolean;
                        onLeft: boolean;
                        onRight: boolean;
                        classes: (string | Object)[];
                        locale: {
                            id: any;
                            daysInWeek: number;
                            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                            masks: any;
                            timezone: string | undefined;
                            hourLabels: string[];
                            dayNames: string[];
                            dayNamesShort: string[];
                            dayNamesShorter: string[];
                            dayNamesNarrow: string[];
                            monthNames: string[];
                            monthNamesShort: string[];
                            relativeTimeNames: {
                                day?: string | undefined;
                                week?: string | undefined;
                                month?: string | undefined;
                                year?: string | undefined;
                                days?: string | undefined;
                                weeks?: string | undefined;
                                seconds?: string | undefined;
                                minutes?: string | undefined;
                                hours?: string | undefined;
                                months?: string | undefined;
                                years?: string | undefined;
                                quarter?: string | undefined;
                                quarters?: string | undefined;
                                hour?: string | undefined;
                                minute?: string | undefined;
                                second?: string | undefined;
                            };
                            amPm: [string, string];
                            monthCache: {
                                keys: string[];
                                store: Record<string, import("../utils/date/helpers").MonthParts>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            };
                            pageCache: {
                                keys: string[];
                                store: Record<string, import("../utils/page").CachedPage>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                                get: (...args: any[]) => import("../utils/page").CachedPage;
                                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                            };
                            formatDate: (date: Date, masks: string | string[]) => string;
                            parseDate: (dateString: string, mask: string | string[]) => Date;
                            toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                            toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                            range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                            getDateParts: (date: Date) => DateParts;
                            getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getHourLabels: () => string[];
                            getDayId: (date: Date) => string;
                        };
                        dayIndex: number;
                        day: number;
                        dayFromEnd: number;
                        weekday: number;
                        weekdayOrdinal: number;
                        weekdayOrdinalFromEnd: number;
                        week: number;
                        weekFromEnd: number;
                        weeknumber: number;
                        month: number;
                        year: number;
                        date: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                    }[];
                    title: string;
                }[];
                weekdays: {
                    weekday: number;
                    label: string;
                }[];
                viewDays: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                viewWeeks: {
                    id: string;
                    week: number;
                    weekPosition: number;
                    weeknumber: number;
                    isoWeeknumber: number;
                    weeknumberDisplay?: number | undefined;
                    days: {
                        id: string;
                        position: number;
                        label: string;
                        ariaLabel: string;
                        weekdayPosition: number;
                        weekdayPositionFromEnd: number;
                        weekPosition: number;
                        isoWeeknumber: number;
                        startDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        noonDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        endDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        isToday: boolean;
                        isFirstDay: boolean;
                        isLastDay: boolean;
                        isDisabled: boolean;
                        isFocusable: boolean;
                        isFocused: boolean;
                        inMonth: boolean;
                        inPrevMonth: boolean;
                        inNextMonth: boolean;
                        onTop: boolean;
                        onBottom: boolean;
                        onLeft: boolean;
                        onRight: boolean;
                        classes: (string | Object)[];
                        locale: {
                            id: any;
                            daysInWeek: number;
                            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                            masks: any;
                            timezone: string | undefined;
                            hourLabels: string[];
                            dayNames: string[];
                            dayNamesShort: string[];
                            dayNamesShorter: string[];
                            dayNamesNarrow: string[];
                            monthNames: string[];
                            monthNamesShort: string[];
                            relativeTimeNames: {
                                day?: string | undefined;
                                week?: string | undefined;
                                month?: string | undefined;
                                year?: string | undefined;
                                days?: string | undefined;
                                weeks?: string | undefined;
                                seconds?: string | undefined;
                                minutes?: string | undefined;
                                hours?: string | undefined;
                                months?: string | undefined;
                                years?: string | undefined;
                                quarter?: string | undefined;
                                quarters?: string | undefined;
                                hour?: string | undefined;
                                minute?: string | undefined;
                                second?: string | undefined;
                            };
                            amPm: [string, string];
                            monthCache: {
                                keys: string[];
                                store: Record<string, import("../utils/date/helpers").MonthParts>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            };
                            pageCache: {
                                keys: string[];
                                store: Record<string, import("../utils/page").CachedPage>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                                get: (...args: any[]) => import("../utils/page").CachedPage;
                                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                            };
                            formatDate: (date: Date, masks: string | string[]) => string;
                            parseDate: (dateString: string, mask: string | string[]) => Date;
                            toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                            toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                            range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                            getDateParts: (date: Date) => DateParts;
                            getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getHourLabels: () => string[];
                            getDayId: (date: Date) => string;
                        };
                        dayIndex: number;
                        day: number;
                        dayFromEnd: number;
                        weekday: number;
                        weekdayOrdinal: number;
                        weekdayOrdinalFromEnd: number;
                        week: number;
                        weekFromEnd: number;
                        weeknumber: number;
                        month: number;
                        year: number;
                        date: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                    }[];
                    title: string;
                }[];
            }[]>;
            transitionName: import("vue").Ref<string>;
            theme: import("vue").ComputedRef<import("../utils/theme").Theme>;
            color: import("vue").ComputedRef<string>;
            displayMode: import("vue").ComputedRef<"light" | "dark">;
            locale: import("vue").ComputedRef<import("../utils/locale").default>;
            masks: import("vue").ComputedRef<any>;
            attributes: import("vue").ComputedRef<import("../utils/attribute").Attribute[]>;
            disabledAttribute: import("vue").ComputedRef<import("../utils/attribute").Attribute>;
            disabledDates: import("vue").ComputedRef<import("../utils/date/range").DateRange[]>;
            attributeContext: import("vue").ComputedRef<import("../utils/date/range").DateRangeContext>;
            days: import("vue").ComputedRef<import("../utils/page").CalendarDay[]>;
            dayCells: import("vue").ComputedRef<import("./calendar").DayCells>;
            count: import("vue").ComputedRef<number>;
            step: import("vue").ComputedRef<number>;
            firstPage: import("vue").ComputedRef<{
                id: string;
                day?: number | undefined;
                week?: number | undefined;
                month: number;
                year: number;
                view: import("../utils/page").PageView;
                trimWeeks: boolean;
                position: number;
                row: number;
                rowFromEnd: number;
                column: number;
                columnFromEnd: number;
                showWeeknumbers: boolean;
                showIsoWeeknumbers: boolean;
                weeknumberPosition: string;
                monthTitle: string;
                weekTitle?: string | undefined;
                dayTitle?: string | undefined;
                title: string;
                titlePosition: import("../utils/page").TitlePosition;
                shortMonthLabel: string;
                monthLabel: string;
                shortYearLabel: string;
                yearLabel: string;
                monthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                prevMonthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                nextMonthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                weeks: {
                    id: string;
                    week: number;
                    weekPosition: number;
                    weeknumber: number;
                    isoWeeknumber: number;
                    weeknumberDisplay?: number | undefined;
                    days: {
                        id: string;
                        position: number;
                        label: string;
                        ariaLabel: string;
                        weekdayPosition: number;
                        weekdayPositionFromEnd: number;
                        weekPosition: number;
                        isoWeeknumber: number;
                        startDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        noonDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        endDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        isToday: boolean;
                        isFirstDay: boolean;
                        isLastDay: boolean;
                        isDisabled: boolean;
                        isFocusable: boolean;
                        isFocused: boolean;
                        inMonth: boolean;
                        inPrevMonth: boolean;
                        inNextMonth: boolean;
                        onTop: boolean;
                        onBottom: boolean;
                        onLeft: boolean;
                        onRight: boolean;
                        classes: (string | Object)[];
                        locale: {
                            id: any;
                            daysInWeek: number;
                            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                            masks: any;
                            timezone: string | undefined;
                            hourLabels: string[];
                            dayNames: string[];
                            dayNamesShort: string[];
                            dayNamesShorter: string[];
                            dayNamesNarrow: string[];
                            monthNames: string[];
                            monthNamesShort: string[];
                            relativeTimeNames: {
                                day?: string | undefined;
                                week?: string | undefined;
                                month?: string | undefined;
                                year?: string | undefined;
                                days?: string | undefined;
                                weeks?: string | undefined;
                                seconds?: string | undefined;
                                minutes?: string | undefined;
                                hours?: string | undefined;
                                months?: string | undefined;
                                years?: string | undefined;
                                quarter?: string | undefined;
                                quarters?: string | undefined;
                                hour?: string | undefined;
                                minute?: string | undefined;
                                second?: string | undefined;
                            };
                            amPm: [string, string];
                            monthCache: {
                                keys: string[];
                                store: Record<string, import("../utils/date/helpers").MonthParts>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            };
                            pageCache: {
                                keys: string[];
                                store: Record<string, import("../utils/page").CachedPage>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                                get: (...args: any[]) => import("../utils/page").CachedPage;
                                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                            };
                            formatDate: (date: Date, masks: string | string[]) => string;
                            parseDate: (dateString: string, mask: string | string[]) => Date;
                            toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                            toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                            range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                            getDateParts: (date: Date) => DateParts;
                            getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getHourLabels: () => string[];
                            getDayId: (date: Date) => string;
                        };
                        dayIndex: number;
                        day: number;
                        dayFromEnd: number;
                        weekday: number;
                        weekdayOrdinal: number;
                        weekdayOrdinalFromEnd: number;
                        week: number;
                        weekFromEnd: number;
                        weeknumber: number;
                        month: number;
                        year: number;
                        date: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                    }[];
                    title: string;
                }[];
                weekdays: {
                    weekday: number;
                    label: string;
                }[];
                viewDays: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                viewWeeks: {
                    id: string;
                    week: number;
                    weekPosition: number;
                    weeknumber: number;
                    isoWeeknumber: number;
                    weeknumberDisplay?: number | undefined;
                    days: {
                        id: string;
                        position: number;
                        label: string;
                        ariaLabel: string;
                        weekdayPosition: number;
                        weekdayPositionFromEnd: number;
                        weekPosition: number;
                        isoWeeknumber: number;
                        startDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        noonDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        endDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        isToday: boolean;
                        isFirstDay: boolean;
                        isLastDay: boolean;
                        isDisabled: boolean;
                        isFocusable: boolean;
                        isFocused: boolean;
                        inMonth: boolean;
                        inPrevMonth: boolean;
                        inNextMonth: boolean;
                        onTop: boolean;
                        onBottom: boolean;
                        onLeft: boolean;
                        onRight: boolean;
                        classes: (string | Object)[];
                        locale: {
                            id: any;
                            daysInWeek: number;
                            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                            masks: any;
                            timezone: string | undefined;
                            hourLabels: string[];
                            dayNames: string[];
                            dayNamesShort: string[];
                            dayNamesShorter: string[];
                            dayNamesNarrow: string[];
                            monthNames: string[];
                            monthNamesShort: string[];
                            relativeTimeNames: {
                                day?: string | undefined;
                                week?: string | undefined;
                                month?: string | undefined;
                                year?: string | undefined;
                                days?: string | undefined;
                                weeks?: string | undefined;
                                seconds?: string | undefined;
                                minutes?: string | undefined;
                                hours?: string | undefined;
                                months?: string | undefined;
                                years?: string | undefined;
                                quarter?: string | undefined;
                                quarters?: string | undefined;
                                hour?: string | undefined;
                                minute?: string | undefined;
                                second?: string | undefined;
                            };
                            amPm: [string, string];
                            monthCache: {
                                keys: string[];
                                store: Record<string, import("../utils/date/helpers").MonthParts>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            };
                            pageCache: {
                                keys: string[];
                                store: Record<string, import("../utils/page").CachedPage>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                                get: (...args: any[]) => import("../utils/page").CachedPage;
                                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                            };
                            formatDate: (date: Date, masks: string | string[]) => string;
                            parseDate: (dateString: string, mask: string | string[]) => Date;
                            toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                            toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                            range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                            getDateParts: (date: Date) => DateParts;
                            getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getHourLabels: () => string[];
                            getDayId: (date: Date) => string;
                        };
                        dayIndex: number;
                        day: number;
                        dayFromEnd: number;
                        weekday: number;
                        weekdayOrdinal: number;
                        weekdayOrdinalFromEnd: number;
                        week: number;
                        weekFromEnd: number;
                        weeknumber: number;
                        month: number;
                        year: number;
                        date: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                    }[];
                    title: string;
                }[];
            } | null>;
            lastPage: import("vue").ComputedRef<{
                id: string;
                day?: number | undefined;
                week?: number | undefined;
                month: number;
                year: number;
                view: import("../utils/page").PageView;
                trimWeeks: boolean;
                position: number;
                row: number;
                rowFromEnd: number;
                column: number;
                columnFromEnd: number;
                showWeeknumbers: boolean;
                showIsoWeeknumbers: boolean;
                weeknumberPosition: string;
                monthTitle: string;
                weekTitle?: string | undefined;
                dayTitle?: string | undefined;
                title: string;
                titlePosition: import("../utils/page").TitlePosition;
                shortMonthLabel: string;
                monthLabel: string;
                shortYearLabel: string;
                yearLabel: string;
                monthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                prevMonthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                nextMonthComps: {
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    firstDayOfMonth: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    inLeapYear: boolean;
                    firstWeekday: number;
                    numDays: number;
                    numWeeks: number;
                    month: number;
                    year: number;
                    weeknumbers: number[];
                    isoWeeknumbers: number[];
                };
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                weeks: {
                    id: string;
                    week: number;
                    weekPosition: number;
                    weeknumber: number;
                    isoWeeknumber: number;
                    weeknumberDisplay?: number | undefined;
                    days: {
                        id: string;
                        position: number;
                        label: string;
                        ariaLabel: string;
                        weekdayPosition: number;
                        weekdayPositionFromEnd: number;
                        weekPosition: number;
                        isoWeeknumber: number;
                        startDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        noonDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        endDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        isToday: boolean;
                        isFirstDay: boolean;
                        isLastDay: boolean;
                        isDisabled: boolean;
                        isFocusable: boolean;
                        isFocused: boolean;
                        inMonth: boolean;
                        inPrevMonth: boolean;
                        inNextMonth: boolean;
                        onTop: boolean;
                        onBottom: boolean;
                        onLeft: boolean;
                        onRight: boolean;
                        classes: (string | Object)[];
                        locale: {
                            id: any;
                            daysInWeek: number;
                            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                            masks: any;
                            timezone: string | undefined;
                            hourLabels: string[];
                            dayNames: string[];
                            dayNamesShort: string[];
                            dayNamesShorter: string[];
                            dayNamesNarrow: string[];
                            monthNames: string[];
                            monthNamesShort: string[];
                            relativeTimeNames: {
                                day?: string | undefined;
                                week?: string | undefined;
                                month?: string | undefined;
                                year?: string | undefined;
                                days?: string | undefined;
                                weeks?: string | undefined;
                                seconds?: string | undefined;
                                minutes?: string | undefined;
                                hours?: string | undefined;
                                months?: string | undefined;
                                years?: string | undefined;
                                quarter?: string | undefined;
                                quarters?: string | undefined;
                                hour?: string | undefined;
                                minute?: string | undefined;
                                second?: string | undefined;
                            };
                            amPm: [string, string];
                            monthCache: {
                                keys: string[];
                                store: Record<string, import("../utils/date/helpers").MonthParts>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            };
                            pageCache: {
                                keys: string[];
                                store: Record<string, import("../utils/page").CachedPage>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                                get: (...args: any[]) => import("../utils/page").CachedPage;
                                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                            };
                            formatDate: (date: Date, masks: string | string[]) => string;
                            parseDate: (dateString: string, mask: string | string[]) => Date;
                            toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                            toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                            range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                            getDateParts: (date: Date) => DateParts;
                            getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getHourLabels: () => string[];
                            getDayId: (date: Date) => string;
                        };
                        dayIndex: number;
                        day: number;
                        dayFromEnd: number;
                        weekday: number;
                        weekdayOrdinal: number;
                        weekdayOrdinalFromEnd: number;
                        week: number;
                        weekFromEnd: number;
                        weeknumber: number;
                        month: number;
                        year: number;
                        date: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                    }[];
                    title: string;
                }[];
                weekdays: {
                    weekday: number;
                    label: string;
                }[];
                viewDays: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                viewWeeks: {
                    id: string;
                    week: number;
                    weekPosition: number;
                    weeknumber: number;
                    isoWeeknumber: number;
                    weeknumberDisplay?: number | undefined;
                    days: {
                        id: string;
                        position: number;
                        label: string;
                        ariaLabel: string;
                        weekdayPosition: number;
                        weekdayPositionFromEnd: number;
                        weekPosition: number;
                        isoWeeknumber: number;
                        startDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        noonDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        endDate: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                        isToday: boolean;
                        isFirstDay: boolean;
                        isLastDay: boolean;
                        isDisabled: boolean;
                        isFocusable: boolean;
                        isFocused: boolean;
                        inMonth: boolean;
                        inPrevMonth: boolean;
                        inNextMonth: boolean;
                        onTop: boolean;
                        onBottom: boolean;
                        onLeft: boolean;
                        onRight: boolean;
                        classes: (string | Object)[];
                        locale: {
                            id: any;
                            daysInWeek: number;
                            firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                            masks: any;
                            timezone: string | undefined;
                            hourLabels: string[];
                            dayNames: string[];
                            dayNamesShort: string[];
                            dayNamesShorter: string[];
                            dayNamesNarrow: string[];
                            monthNames: string[];
                            monthNamesShort: string[];
                            relativeTimeNames: {
                                day?: string | undefined;
                                week?: string | undefined;
                                month?: string | undefined;
                                year?: string | undefined;
                                days?: string | undefined;
                                weeks?: string | undefined;
                                seconds?: string | undefined;
                                minutes?: string | undefined;
                                hours?: string | undefined;
                                months?: string | undefined;
                                years?: string | undefined;
                                quarter?: string | undefined;
                                quarters?: string | undefined;
                                hour?: string | undefined;
                                minute?: string | undefined;
                                second?: string | undefined;
                            };
                            amPm: [string, string];
                            monthCache: {
                                keys: string[];
                                store: Record<string, import("../utils/date/helpers").MonthParts>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                                getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            };
                            pageCache: {
                                keys: string[];
                                store: Record<string, import("../utils/page").CachedPage>;
                                size: number;
                                createKey: (...args: any[]) => string;
                                createItem: (...args: any[]) => import("../utils/page").CachedPage;
                                get: (...args: any[]) => import("../utils/page").CachedPage;
                                getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                            };
                            formatDate: (date: Date, masks: string | string[]) => string;
                            parseDate: (dateString: string, mask: string | string[]) => Date;
                            toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                            toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                            fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                            range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                            ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                            getDateParts: (date: Date) => DateParts;
                            getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                            getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                            getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                            getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                            getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                            getHourLabels: () => string[];
                            getDayId: (date: Date) => string;
                        };
                        dayIndex: number;
                        day: number;
                        dayFromEnd: number;
                        weekday: number;
                        weekdayOrdinal: number;
                        weekdayOrdinalFromEnd: number;
                        week: number;
                        weekFromEnd: number;
                        weeknumber: number;
                        month: number;
                        year: number;
                        date: {
                            toString: () => string;
                            toDateString: () => string;
                            toTimeString: () => string;
                            toLocaleString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleDateString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            toLocaleTimeString: {
                                (): string;
                                (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                                (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                            };
                            valueOf: () => number;
                            getTime: () => number;
                            getFullYear: () => number;
                            getUTCFullYear: () => number;
                            getMonth: () => number;
                            getUTCMonth: () => number;
                            getDate: () => number;
                            getUTCDate: () => number;
                            getDay: () => number;
                            getUTCDay: () => number;
                            getHours: () => number;
                            getUTCHours: () => number;
                            getMinutes: () => number;
                            getUTCMinutes: () => number;
                            getSeconds: () => number;
                            getUTCSeconds: () => number;
                            getMilliseconds: () => number;
                            getUTCMilliseconds: () => number;
                            getTimezoneOffset: () => number;
                            setTime: (time: number) => number;
                            setMilliseconds: (ms: number) => number;
                            setUTCMilliseconds: (ms: number) => number;
                            setSeconds: (sec: number, ms?: number | undefined) => number;
                            setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                            setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                            setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                            setDate: (date: number) => number;
                            setUTCDate: (date: number) => number;
                            setMonth: (month: number, date?: number | undefined) => number;
                            setUTCMonth: (month: number, date?: number | undefined) => number;
                            setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                            toUTCString: () => string;
                            toISOString: () => string;
                            toJSON: (key?: any) => string;
                            getVarDate: () => VarDate;
                            [Symbol.toPrimitive]: {
                                (hint: "default"): string;
                                (hint: "string"): string;
                                (hint: "number"): number;
                                (hint: string): string | number;
                            };
                        };
                    }[];
                    title: string;
                }[];
            } | null>;
            canMovePrev: import("vue").ComputedRef<boolean>;
            canMoveNext: import("vue").ComputedRef<boolean>;
            minPage: import("vue").ComputedRef<import("../utils/page").PageAddress | null>;
            maxPage: import("vue").ComputedRef<import("../utils/page").PageAddress | null>;
            isMonthly: import("vue").ComputedRef<boolean>;
            isWeekly: import("vue").ComputedRef<boolean>;
            isDaily: import("vue").ComputedRef<boolean>;
            navVisibility: import("vue").ComputedRef<import("../utils/popovers").PopoverVisibility>;
            showWeeknumbers: import("vue").ComputedRef<boolean>;
            showIsoWeeknumbers: import("vue").ComputedRef<boolean>;
            getDateAddress: (date: import("../utils/date/helpers").DateSource) => import("../utils/page").PageAddress;
            canMove: (target: import("./calendar").MoveTarget, opts?: Partial<import("./calendar").MoveOptions>) => boolean;
            canMoveBy: (pages: number, opts?: Partial<import("./calendar").MoveOptions>) => boolean;
            move: (target: import("./calendar").MoveTarget, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
            moveBy: (pages: number, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
            movePrev: () => Promise<boolean>;
            moveNext: () => Promise<boolean>;
            onTransitionBeforeEnter: () => void;
            onTransitionAfterEnter: () => void;
            tryFocusDate: (date: Date) => boolean;
            focusDate: (date: Date, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
            onKeydown: (event: KeyboardEvent) => void;
            onDayKeydown: (day: import("../utils/page").CalendarDay, event: KeyboardEvent) => void;
            onDayClick: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
            onDayMouseenter: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
            onDayMouseleave: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
            onDayFocusin: (day: import("../utils/page").CalendarDay, event: FocusEvent | null) => void;
            onDayFocusout: (day: import("../utils/page").CalendarDay, event: FocusEvent) => void;
            onWeeknumberClick: (week: import("../utils/page").CalendarWeek, event: MouseEvent) => void;
        }, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, {
            view: import("./calendar").CalendarView;
            trimWeeks: boolean;
            titlePosition: import("../utils/page").TitlePosition;
            color: string;
            isDark: boolean | "system" | import("vue-screen-utils").DarkModeClassConfig;
            navVisibility: import("../utils/popovers").PopoverVisibility;
            rows: number;
            columns: number;
            expanded: boolean;
            borderless: boolean;
            transparent: boolean;
            initialPagePosition: number;
            disablePageSwipe: boolean;
        }, {}, string> & {
            beforeCreate?: ((() => void) | (() => void)[]) | undefined;
            created?: ((() => void) | (() => void)[]) | undefined;
            beforeMount?: ((() => void) | (() => void)[]) | undefined;
            mounted?: ((() => void) | (() => void)[]) | undefined;
            beforeUpdate?: ((() => void) | (() => void)[]) | undefined;
            updated?: ((() => void) | (() => void)[]) | undefined;
            activated?: ((() => void) | (() => void)[]) | undefined;
            deactivated?: ((() => void) | (() => void)[]) | undefined;
            beforeDestroy?: ((() => void) | (() => void)[]) | undefined;
            beforeUnmount?: ((() => void) | (() => void)[]) | undefined;
            destroyed?: ((() => void) | (() => void)[]) | undefined;
            unmounted?: ((() => void) | (() => void)[]) | undefined;
            renderTracked?: (((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[]) | undefined;
            renderTriggered?: (((e: import("vue").DebuggerEvent) => void) | ((e: import("vue").DebuggerEvent) => void)[]) | undefined;
            errorCaptured?: (((err: unknown, instance: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null, info: string) => boolean | void) | ((err: unknown, instance: import("vue").ComponentPublicInstance<{}, {}, {}, {}, {}, {}, {}, {}, false, import("vue").ComponentOptionsBase<any, any, any, any, any, any, any, any, any, {}, {}, string>, {}> | null, info: string) => boolean | void)[]) | undefined;
        };
        $forceUpdate: () => void;
        $nextTick: typeof import("vue").nextTick;
        $watch<T extends string | ((...args: any) => any)>(source: T, cb: T extends (...args: any) => infer R ? (args_0: R, args_1: R) => any : (...args: any) => any, options?: import("vue").WatchOptions<boolean> | undefined): import("vue").WatchStopHandle;
    } & Readonly<import("vue").ExtractPropTypes<{
        view: {
            type: import("vue").PropType<import("./calendar").CalendarView>;
            default: string;
            validator(value: string): boolean;
        };
        rows: {
            type: NumberConstructor;
            default: number;
        };
        columns: {
            type: NumberConstructor;
            default: number;
        };
        step: NumberConstructor;
        titlePosition: {
            type: import("vue").PropType<import("../utils/page").TitlePosition>;
            default: () => import("../utils/page").TitlePosition;
        };
        navVisibility: {
            type: import("vue").PropType<import("../utils/popovers").PopoverVisibility>;
            default: () => import("../utils/popovers").PopoverVisibility;
        };
        showWeeknumbers: (BooleanConstructor | StringConstructor)[];
        showIsoWeeknumbers: (BooleanConstructor | StringConstructor)[];
        expanded: BooleanConstructor;
        borderless: BooleanConstructor;
        transparent: BooleanConstructor;
        initialPage: import("vue").PropType<import("../utils/page").PageAddress>;
        initialPagePosition: {
            type: NumberConstructor;
            default: number;
        };
        minPage: import("vue").PropType<import("../utils/page").PageAddress>;
        maxPage: import("vue").PropType<import("../utils/page").PageAddress>;
        transition: import("vue").PropType<import("./calendar").MoveTransition>;
        attributes: import("vue").PropType<Partial<{
            key: string | number;
            hashcode: string;
            content: import("../utils/glyph").ContentConfig;
            highlight: import("../utils/glyph").HighlightConfig;
            dot: import("../utils/glyph").DotConfig;
            bar: import("../utils/glyph").BarConfig;
            popover: Partial<{
                label: string;
                visibility: import("../utils/popovers").PopoverVisibility;
                placement: import("@popperjs/core").Placement;
                hideIndicator: boolean;
                isInteractive: boolean;
            }>;
            event: Partial<{
                label: string;
            }>;
            dates: import("../utils/date/range").DateRangeSource[];
            customData: any;
            order: number;
            pinPage: boolean;
        }>[]>;
        trimWeeks: BooleanConstructor;
        disablePageSwipe: BooleanConstructor;
        color: {
            type: StringConstructor;
            default: () => any;
        };
        isDark: {
            type: import("vue").PropType<boolean | "system" | import("vue-screen-utils").DarkModeClassConfig>;
            default: () => any;
        };
        firstDayOfWeek: import("vue").PropType<import("../utils/date/helpers").DayOfWeek>;
        masks: ObjectConstructor;
        locale: import("vue").PropType<string | import("../utils/locale").default | Record<string, any>>;
        timezone: StringConstructor;
        minDate: null;
        maxDate: null;
        disabledDates: null;
    }>> & import("vue").ShallowUnwrapRef<{
        emit: ((event: string, ...args: any[]) => void) | ((event: string, ...args: any[]) => void);
        containerRef: import("vue").Ref<{
            querySelector: {
                <K extends keyof HTMLElementTagNameMap>(selectors: K): HTMLElementTagNameMap[K] | null;
                <K_1 extends keyof SVGElementTagNameMap>(selectors: K_1): SVGElementTagNameMap[K_1] | null;
                <E extends Element = Element>(selectors: string): E | null;
            };
            addEventListener: Function;
            removeEventListener: Function;
            dispatchEvent: Function;
        } | null>;
        focusedDay: import("vue").Ref<{
            id: string;
            position: number;
            label: string;
            ariaLabel: string;
            weekdayPosition: number;
            weekdayPositionFromEnd: number;
            weekPosition: number;
            isoWeeknumber: number;
            startDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            noonDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            endDate: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
            isToday: boolean;
            isFirstDay: boolean;
            isLastDay: boolean;
            isDisabled: boolean;
            isFocusable: boolean;
            isFocused: boolean;
            inMonth: boolean;
            inPrevMonth: boolean;
            inNextMonth: boolean;
            onTop: boolean;
            onBottom: boolean;
            onLeft: boolean;
            onRight: boolean;
            classes: (string | Object)[];
            locale: {
                id: any;
                daysInWeek: number;
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                masks: any;
                timezone: string | undefined;
                hourLabels: string[];
                dayNames: string[];
                dayNamesShort: string[];
                dayNamesShorter: string[];
                dayNamesNarrow: string[];
                monthNames: string[];
                monthNamesShort: string[];
                relativeTimeNames: {
                    day?: string | undefined;
                    week?: string | undefined;
                    month?: string | undefined;
                    year?: string | undefined;
                    days?: string | undefined;
                    weeks?: string | undefined;
                    seconds?: string | undefined;
                    minutes?: string | undefined;
                    hours?: string | undefined;
                    months?: string | undefined;
                    years?: string | undefined;
                    quarter?: string | undefined;
                    quarters?: string | undefined;
                    hour?: string | undefined;
                    minute?: string | undefined;
                    second?: string | undefined;
                };
                amPm: [string, string];
                monthCache: {
                    keys: string[];
                    store: Record<string, import("../utils/date/helpers").MonthParts>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                };
                pageCache: {
                    keys: string[];
                    store: Record<string, import("../utils/page").CachedPage>;
                    size: number;
                    createKey: (...args: any[]) => string;
                    createItem: (...args: any[]) => import("../utils/page").CachedPage;
                    get: (...args: any[]) => import("../utils/page").CachedPage;
                    getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                };
                formatDate: (date: Date, masks: string | string[]) => string;
                parseDate: (dateString: string, mask: string | string[]) => Date;
                toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                getDateParts: (date: Date) => DateParts;
                getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                getHourLabels: () => string[];
                getDayId: (date: Date) => string;
            };
            dayIndex: number;
            day: number;
            dayFromEnd: number;
            weekday: number;
            weekdayOrdinal: number;
            weekdayOrdinalFromEnd: number;
            week: number;
            weekFromEnd: number;
            weeknumber: number;
            month: number;
            year: number;
            date: {
                toString: () => string;
                toDateString: () => string;
                toTimeString: () => string;
                toLocaleString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleDateString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                toLocaleTimeString: {
                    (): string;
                    (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                    (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                };
                valueOf: () => number;
                getTime: () => number;
                getFullYear: () => number;
                getUTCFullYear: () => number;
                getMonth: () => number;
                getUTCMonth: () => number;
                getDate: () => number;
                getUTCDate: () => number;
                getDay: () => number;
                getUTCDay: () => number;
                getHours: () => number;
                getUTCHours: () => number;
                getMinutes: () => number;
                getUTCMinutes: () => number;
                getSeconds: () => number;
                getUTCSeconds: () => number;
                getMilliseconds: () => number;
                getUTCMilliseconds: () => number;
                getTimezoneOffset: () => number;
                setTime: (time: number) => number;
                setMilliseconds: (ms: number) => number;
                setUTCMilliseconds: (ms: number) => number;
                setSeconds: (sec: number, ms?: number | undefined) => number;
                setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                setDate: (date: number) => number;
                setUTCDate: (date: number) => number;
                setMonth: (month: number, date?: number | undefined) => number;
                setUTCMonth: (month: number, date?: number | undefined) => number;
                setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                toUTCString: () => string;
                toISOString: () => string;
                toJSON: (key?: any) => string;
                getVarDate: () => VarDate;
                [Symbol.toPrimitive]: {
                    (hint: "default"): string;
                    (hint: "string"): string;
                    (hint: "number"): number;
                    (hint: string): string | number;
                };
            };
        } | null>;
        inTransition: import("vue").Ref<boolean>;
        navPopoverId: import("vue").Ref<symbol>;
        dayPopoverId: import("vue").Ref<symbol>;
        view: import("vue").Ref<import("./calendar").CalendarView>;
        pages: import("vue").Ref<{
            id: string;
            day?: number | undefined;
            week?: number | undefined;
            month: number;
            year: number;
            view: import("../utils/page").PageView;
            trimWeeks: boolean;
            position: number;
            row: number;
            rowFromEnd: number;
            column: number;
            columnFromEnd: number;
            showWeeknumbers: boolean;
            showIsoWeeknumbers: boolean;
            weeknumberPosition: string;
            monthTitle: string;
            weekTitle?: string | undefined;
            dayTitle?: string | undefined;
            title: string;
            titlePosition: import("../utils/page").TitlePosition;
            shortMonthLabel: string;
            monthLabel: string;
            shortYearLabel: string;
            yearLabel: string;
            monthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            prevMonthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            nextMonthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => DateParts;
                    getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            weeks: {
                id: string;
                week: number;
                weekPosition: number;
                weeknumber: number;
                isoWeeknumber: number;
                weeknumberDisplay?: number | undefined;
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                title: string;
            }[];
            weekdays: {
                weekday: number;
                label: string;
            }[];
            viewDays: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => DateParts;
                    getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            viewWeeks: {
                id: string;
                week: number;
                weekPosition: number;
                weeknumber: number;
                isoWeeknumber: number;
                weeknumberDisplay?: number | undefined;
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                title: string;
            }[];
        }[]>;
        transitionName: import("vue").Ref<string>;
        theme: import("vue").ComputedRef<import("../utils/theme").Theme>;
        color: import("vue").ComputedRef<string>;
        displayMode: import("vue").ComputedRef<"light" | "dark">;
        locale: import("vue").ComputedRef<import("../utils/locale").default>;
        masks: import("vue").ComputedRef<any>;
        attributes: import("vue").ComputedRef<import("../utils/attribute").Attribute[]>;
        disabledAttribute: import("vue").ComputedRef<import("../utils/attribute").Attribute>;
        disabledDates: import("vue").ComputedRef<import("../utils/date/range").DateRange[]>;
        attributeContext: import("vue").ComputedRef<import("../utils/date/range").DateRangeContext>;
        days: import("vue").ComputedRef<import("../utils/page").CalendarDay[]>;
        dayCells: import("vue").ComputedRef<import("./calendar").DayCells>;
        count: import("vue").ComputedRef<number>;
        step: import("vue").ComputedRef<number>;
        firstPage: import("vue").ComputedRef<{
            id: string;
            day?: number | undefined;
            week?: number | undefined;
            month: number;
            year: number;
            view: import("../utils/page").PageView;
            trimWeeks: boolean;
            position: number;
            row: number;
            rowFromEnd: number;
            column: number;
            columnFromEnd: number;
            showWeeknumbers: boolean;
            showIsoWeeknumbers: boolean;
            weeknumberPosition: string;
            monthTitle: string;
            weekTitle?: string | undefined;
            dayTitle?: string | undefined;
            title: string;
            titlePosition: import("../utils/page").TitlePosition;
            shortMonthLabel: string;
            monthLabel: string;
            shortYearLabel: string;
            yearLabel: string;
            monthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            prevMonthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            nextMonthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => DateParts;
                    getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            weeks: {
                id: string;
                week: number;
                weekPosition: number;
                weeknumber: number;
                isoWeeknumber: number;
                weeknumberDisplay?: number | undefined;
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                title: string;
            }[];
            weekdays: {
                weekday: number;
                label: string;
            }[];
            viewDays: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => DateParts;
                    getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            viewWeeks: {
                id: string;
                week: number;
                weekPosition: number;
                weeknumber: number;
                isoWeeknumber: number;
                weeknumberDisplay?: number | undefined;
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                title: string;
            }[];
        } | null>;
        lastPage: import("vue").ComputedRef<{
            id: string;
            day?: number | undefined;
            week?: number | undefined;
            month: number;
            year: number;
            view: import("../utils/page").PageView;
            trimWeeks: boolean;
            position: number;
            row: number;
            rowFromEnd: number;
            column: number;
            columnFromEnd: number;
            showWeeknumbers: boolean;
            showIsoWeeknumbers: boolean;
            weeknumberPosition: string;
            monthTitle: string;
            weekTitle?: string | undefined;
            dayTitle?: string | undefined;
            title: string;
            titlePosition: import("../utils/page").TitlePosition;
            shortMonthLabel: string;
            monthLabel: string;
            shortYearLabel: string;
            yearLabel: string;
            monthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            prevMonthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            nextMonthComps: {
                firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                firstDayOfMonth: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                inLeapYear: boolean;
                firstWeekday: number;
                numDays: number;
                numWeeks: number;
                month: number;
                year: number;
                weeknumbers: number[];
                isoWeeknumbers: number[];
            };
            days: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => DateParts;
                    getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            weeks: {
                id: string;
                week: number;
                weekPosition: number;
                weeknumber: number;
                isoWeeknumber: number;
                weeknumberDisplay?: number | undefined;
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                title: string;
            }[];
            weekdays: {
                weekday: number;
                label: string;
            }[];
            viewDays: {
                id: string;
                position: number;
                label: string;
                ariaLabel: string;
                weekdayPosition: number;
                weekdayPositionFromEnd: number;
                weekPosition: number;
                isoWeeknumber: number;
                startDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                noonDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                endDate: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
                isToday: boolean;
                isFirstDay: boolean;
                isLastDay: boolean;
                isDisabled: boolean;
                isFocusable: boolean;
                isFocused: boolean;
                inMonth: boolean;
                inPrevMonth: boolean;
                inNextMonth: boolean;
                onTop: boolean;
                onBottom: boolean;
                onLeft: boolean;
                onRight: boolean;
                classes: (string | Object)[];
                locale: {
                    id: any;
                    daysInWeek: number;
                    firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                    masks: any;
                    timezone: string | undefined;
                    hourLabels: string[];
                    dayNames: string[];
                    dayNamesShort: string[];
                    dayNamesShorter: string[];
                    dayNamesNarrow: string[];
                    monthNames: string[];
                    monthNamesShort: string[];
                    relativeTimeNames: {
                        day?: string | undefined;
                        week?: string | undefined;
                        month?: string | undefined;
                        year?: string | undefined;
                        days?: string | undefined;
                        weeks?: string | undefined;
                        seconds?: string | undefined;
                        minutes?: string | undefined;
                        hours?: string | undefined;
                        months?: string | undefined;
                        years?: string | undefined;
                        quarter?: string | undefined;
                        quarters?: string | undefined;
                        hour?: string | undefined;
                        minute?: string | undefined;
                        second?: string | undefined;
                    };
                    amPm: [string, string];
                    monthCache: {
                        keys: string[];
                        store: Record<string, import("../utils/date/helpers").MonthParts>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                    };
                    pageCache: {
                        keys: string[];
                        store: Record<string, import("../utils/page").CachedPage>;
                        size: number;
                        createKey: (...args: any[]) => string;
                        createItem: (...args: any[]) => import("../utils/page").CachedPage;
                        get: (...args: any[]) => import("../utils/page").CachedPage;
                        getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                    };
                    formatDate: (date: Date, masks: string | string[]) => string;
                    parseDate: (dateString: string, mask: string | string[]) => Date;
                    toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                    toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                    fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                    range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                    ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                    getDateParts: (date: Date) => DateParts;
                    getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                    getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                    getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                    getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                    getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                    getHourLabels: () => string[];
                    getDayId: (date: Date) => string;
                };
                dayIndex: number;
                day: number;
                dayFromEnd: number;
                weekday: number;
                weekdayOrdinal: number;
                weekdayOrdinalFromEnd: number;
                week: number;
                weekFromEnd: number;
                weeknumber: number;
                month: number;
                year: number;
                date: {
                    toString: () => string;
                    toDateString: () => string;
                    toTimeString: () => string;
                    toLocaleString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleDateString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    toLocaleTimeString: {
                        (): string;
                        (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                        (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                    };
                    valueOf: () => number;
                    getTime: () => number;
                    getFullYear: () => number;
                    getUTCFullYear: () => number;
                    getMonth: () => number;
                    getUTCMonth: () => number;
                    getDate: () => number;
                    getUTCDate: () => number;
                    getDay: () => number;
                    getUTCDay: () => number;
                    getHours: () => number;
                    getUTCHours: () => number;
                    getMinutes: () => number;
                    getUTCMinutes: () => number;
                    getSeconds: () => number;
                    getUTCSeconds: () => number;
                    getMilliseconds: () => number;
                    getUTCMilliseconds: () => number;
                    getTimezoneOffset: () => number;
                    setTime: (time: number) => number;
                    setMilliseconds: (ms: number) => number;
                    setUTCMilliseconds: (ms: number) => number;
                    setSeconds: (sec: number, ms?: number | undefined) => number;
                    setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                    setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                    setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                    setDate: (date: number) => number;
                    setUTCDate: (date: number) => number;
                    setMonth: (month: number, date?: number | undefined) => number;
                    setUTCMonth: (month: number, date?: number | undefined) => number;
                    setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                    toUTCString: () => string;
                    toISOString: () => string;
                    toJSON: (key?: any) => string;
                    getVarDate: () => VarDate;
                    [Symbol.toPrimitive]: {
                        (hint: "default"): string;
                        (hint: "string"): string;
                        (hint: "number"): number;
                        (hint: string): string | number;
                    };
                };
            }[];
            viewWeeks: {
                id: string;
                week: number;
                weekPosition: number;
                weeknumber: number;
                isoWeeknumber: number;
                weeknumberDisplay?: number | undefined;
                days: {
                    id: string;
                    position: number;
                    label: string;
                    ariaLabel: string;
                    weekdayPosition: number;
                    weekdayPositionFromEnd: number;
                    weekPosition: number;
                    isoWeeknumber: number;
                    startDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    noonDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    endDate: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                    isToday: boolean;
                    isFirstDay: boolean;
                    isLastDay: boolean;
                    isDisabled: boolean;
                    isFocusable: boolean;
                    isFocused: boolean;
                    inMonth: boolean;
                    inPrevMonth: boolean;
                    inNextMonth: boolean;
                    onTop: boolean;
                    onBottom: boolean;
                    onLeft: boolean;
                    onRight: boolean;
                    classes: (string | Object)[];
                    locale: {
                        id: any;
                        daysInWeek: number;
                        firstDayOfWeek: import("../utils/date/helpers").DayOfWeek;
                        masks: any;
                        timezone: string | undefined;
                        hourLabels: string[];
                        dayNames: string[];
                        dayNamesShort: string[];
                        dayNamesShorter: string[];
                        dayNamesNarrow: string[];
                        monthNames: string[];
                        monthNamesShort: string[];
                        relativeTimeNames: {
                            day?: string | undefined;
                            week?: string | undefined;
                            month?: string | undefined;
                            year?: string | undefined;
                            days?: string | undefined;
                            weeks?: string | undefined;
                            seconds?: string | undefined;
                            minutes?: string | undefined;
                            hours?: string | undefined;
                            months?: string | undefined;
                            years?: string | undefined;
                            quarter?: string | undefined;
                            quarters?: string | undefined;
                            hour?: string | undefined;
                            minute?: string | undefined;
                            second?: string | undefined;
                        };
                        amPm: [string, string];
                        monthCache: {
                            keys: string[];
                            store: Record<string, import("../utils/date/helpers").MonthParts>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            get: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                            getOrSet: (...args: any[]) => import("../utils/date/helpers").MonthParts;
                        };
                        pageCache: {
                            keys: string[];
                            store: Record<string, import("../utils/page").CachedPage>;
                            size: number;
                            createKey: (...args: any[]) => string;
                            createItem: (...args: any[]) => import("../utils/page").CachedPage;
                            get: (...args: any[]) => import("../utils/page").CachedPage;
                            getOrSet: (...args: any[]) => import("../utils/page").CachedPage;
                        };
                        formatDate: (date: Date, masks: string | string[]) => string;
                        parseDate: (dateString: string, mask: string | string[]) => Date;
                        toDate: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date;
                        toDateOrNull: (d: Partial<SimpleDateParts> | import("../utils/date/helpers").DateSource, opts?: Partial<import("../utils/date/helpers").DateOptions>) => Date | null;
                        fromDate: (date: Date | null, { type, mask }?: Partial<import("../utils/date/helpers").DateOptions>) => string | number | Date | DateParts | null;
                        range: (source: import("../utils/date/range").DateRangeSource) => import("../utils/date/range").DateRange;
                        ranges: (ranges: import("../utils/date/range").DateRangeSource | import("../utils/date/range").DateRangeSource[]) => import("../utils/date/range").DateRange[];
                        getDateParts: (date: Date) => DateParts;
                        getDateFromParts: (parts: Partial<SimpleDateParts>) => Date;
                        getDateFromParams: (year: number, month: number, day: number, hours: number, minutes: number, seconds: number, milliseconds: number) => Date;
                        getPage: (config: import("../utils/page").PageConfig) => import("../utils/page").Page;
                        getMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getThisMonthParts: () => import("../utils/date/helpers").MonthParts;
                        getPrevMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getNextMonthParts: (month: number, year: number) => import("../utils/date/helpers").MonthParts;
                        getHourLabels: () => string[];
                        getDayId: (date: Date) => string;
                    };
                    dayIndex: number;
                    day: number;
                    dayFromEnd: number;
                    weekday: number;
                    weekdayOrdinal: number;
                    weekdayOrdinalFromEnd: number;
                    week: number;
                    weekFromEnd: number;
                    weeknumber: number;
                    month: number;
                    year: number;
                    date: {
                        toString: () => string;
                        toDateString: () => string;
                        toTimeString: () => string;
                        toLocaleString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleDateString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        toLocaleTimeString: {
                            (): string;
                            (locales?: string | string[] | undefined, options?: Intl.DateTimeFormatOptions | undefined): string;
                            (locales?: Intl.LocalesArgument, options?: Intl.DateTimeFormatOptions | undefined): string;
                        };
                        valueOf: () => number;
                        getTime: () => number;
                        getFullYear: () => number;
                        getUTCFullYear: () => number;
                        getMonth: () => number;
                        getUTCMonth: () => number;
                        getDate: () => number;
                        getUTCDate: () => number;
                        getDay: () => number;
                        getUTCDay: () => number;
                        getHours: () => number;
                        getUTCHours: () => number;
                        getMinutes: () => number;
                        getUTCMinutes: () => number;
                        getSeconds: () => number;
                        getUTCSeconds: () => number;
                        getMilliseconds: () => number;
                        getUTCMilliseconds: () => number;
                        getTimezoneOffset: () => number;
                        setTime: (time: number) => number;
                        setMilliseconds: (ms: number) => number;
                        setUTCMilliseconds: (ms: number) => number;
                        setSeconds: (sec: number, ms?: number | undefined) => number;
                        setUTCSeconds: (sec: number, ms?: number | undefined) => number;
                        setMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCMinutes: (min: number, sec?: number | undefined, ms?: number | undefined) => number;
                        setHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setUTCHours: (hours: number, min?: number | undefined, sec?: number | undefined, ms?: number | undefined) => number;
                        setDate: (date: number) => number;
                        setUTCDate: (date: number) => number;
                        setMonth: (month: number, date?: number | undefined) => number;
                        setUTCMonth: (month: number, date?: number | undefined) => number;
                        setFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        setUTCFullYear: (year: number, month?: number | undefined, date?: number | undefined) => number;
                        toUTCString: () => string;
                        toISOString: () => string;
                        toJSON: (key?: any) => string;
                        getVarDate: () => VarDate;
                        [Symbol.toPrimitive]: {
                            (hint: "default"): string;
                            (hint: "string"): string;
                            (hint: "number"): number;
                            (hint: string): string | number;
                        };
                    };
                }[];
                title: string;
            }[];
        } | null>;
        canMovePrev: import("vue").ComputedRef<boolean>;
        canMoveNext: import("vue").ComputedRef<boolean>;
        minPage: import("vue").ComputedRef<import("../utils/page").PageAddress | null>;
        maxPage: import("vue").ComputedRef<import("../utils/page").PageAddress | null>;
        isMonthly: import("vue").ComputedRef<boolean>;
        isWeekly: import("vue").ComputedRef<boolean>;
        isDaily: import("vue").ComputedRef<boolean>;
        navVisibility: import("vue").ComputedRef<import("../utils/popovers").PopoverVisibility>;
        showWeeknumbers: import("vue").ComputedRef<boolean>;
        showIsoWeeknumbers: import("vue").ComputedRef<boolean>;
        getDateAddress: (date: import("../utils/date/helpers").DateSource) => import("../utils/page").PageAddress;
        canMove: (target: import("./calendar").MoveTarget, opts?: Partial<import("./calendar").MoveOptions>) => boolean;
        canMoveBy: (pages: number, opts?: Partial<import("./calendar").MoveOptions>) => boolean;
        move: (target: import("./calendar").MoveTarget, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
        moveBy: (pages: number, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
        movePrev: () => Promise<boolean>;
        moveNext: () => Promise<boolean>;
        onTransitionBeforeEnter: () => void;
        onTransitionAfterEnter: () => void;
        tryFocusDate: (date: Date) => boolean;
        focusDate: (date: Date, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
        onKeydown: (event: KeyboardEvent) => void;
        onDayKeydown: (day: import("../utils/page").CalendarDay, event: KeyboardEvent) => void;
        onDayClick: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
        onDayMouseenter: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
        onDayMouseleave: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
        onDayFocusin: (day: import("../utils/page").CalendarDay, event: FocusEvent | null) => void;
        onDayFocusout: (day: import("../utils/page").CalendarDay, event: FocusEvent) => void;
        onWeeknumberClick: (week: import("../utils/page").CalendarWeek, event: MouseEvent) => void;
    }> & {} & import("vue").ComponentCustomProperties & {}) | null>;
    isRange: import("vue").ComputedRef<boolean>;
    isTimeMode: import("vue").ComputedRef<boolean>;
    isDateTimeMode: import("vue").ComputedRef<boolean>;
    hideTimeHeader: import("vue").Ref<boolean>;
    isDragging: import("vue").ComputedRef<boolean>;
    inputValue: import("vue").ComputedRef<string | {
        start: string;
        end: string;
    }>;
    inputEvents: import("vue").ComputedRef<{
        click?: ((e: MouseEvent) => void) | undefined;
        mousemove?: ((e: MouseEvent) => void) | undefined;
        mouseleave?: ((e: MouseEvent) => void) | undefined;
        focusin?: ((e: MouseEvent) => void) | undefined;
        focusout?: ((e: MouseEvent) => void) | undefined;
        input: (e: InputEvent) => void;
        change: (e: InputEvent) => void;
        keyup: (e: KeyboardEvent) => void;
    } | {
        start: {
            click?: ((e: MouseEvent) => void) | undefined;
            mousemove?: ((e: MouseEvent) => void) | undefined;
            mouseleave?: ((e: MouseEvent) => void) | undefined;
            focusin?: ((e: MouseEvent) => void) | undefined;
            focusout?: ((e: MouseEvent) => void) | undefined;
            input: (e: InputEvent) => void;
            change: (e: InputEvent) => void;
            keyup: (e: KeyboardEvent) => void;
        };
        end: {
            click?: ((e: MouseEvent) => void) | undefined;
            mousemove?: ((e: MouseEvent) => void) | undefined;
            mouseleave?: ((e: MouseEvent) => void) | undefined;
            focusin?: ((e: MouseEvent) => void) | undefined;
            focusout?: ((e: MouseEvent) => void) | undefined;
            input: (e: InputEvent) => void;
            change: (e: InputEvent) => void;
            keyup: (e: KeyboardEvent) => void;
        };
    }>;
    dateParts: import("vue").ComputedRef<(DateParts | null)[]>;
    attributes: import("vue").ComputedRef<any[]>;
    rules: import("vue").ComputedRef<import("../utils/date/helpers").DatePartsRules[]>;
    move: (target: import("./calendar").MoveTarget, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
    moveBy: (pages: number, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
    moveToValue: (target: import("../use/datePicker").ValueTarget, opts?: Partial<import("./calendar").MoveOptions>) => Promise<boolean>;
    updateValue: (value: any, opts?: Partial<import("../use/datePicker").UpdateOptions>) => Promise<string | number | Date | DateParts | {
        start: string | number | Date | DateParts | null;
        end: string | number | Date | DateParts | null;
    } | null>;
    showPopover: (opts?: Partial<import("../utils/popovers").PopoverOptions>) => void;
    hidePopover: (opts?: Partial<import("../utils/popovers").PopoverOptions>) => void;
    togglePopover: (opts: Partial<import("../utils/popovers").PopoverOptions>) => void;
    onDayClick: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
    onDayKeydown: (day: import("../utils/page").CalendarDay, event: KeyboardEvent) => void;
    onDayMouseEnter: (day: import("../utils/page").CalendarDay, event: MouseEvent) => void;
    onPopoverBeforeShow: (el: HTMLElement) => void;
    onPopoverAfterShow: (el: HTMLElement) => void;
    onPopoverBeforeHide: (el: HTMLElement) => void;
    onPopoverAfterHide: (el: HTMLElement) => void;
    color: import("vue").ComputedRef<string>;
    isDark: import("vue").ComputedRef<boolean | "system" | import("vue-screen-utils").DarkModeClassConfig>;
    displayMode: import("vue").ComputedRef<"light" | "dark">;
    theme: import("vue").ComputedRef<import("../utils/theme").Theme>;
    locale: import("vue").ComputedRef<import("../utils/locale").default>;
    masks: import("vue").ComputedRef<any>;
    minDate: import("vue").ComputedRef<any>;
    maxDate: import("vue").ComputedRef<any>;
    disabledDates: import("vue").ComputedRef<import("../utils/date/range").DateRange[]>;
    disabledAttribute: import("vue").ComputedRef<import("../utils/attribute").Attribute>;
};
